/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ui;

import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.validation.ValidationService;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateDialog
extends Dialog {
    private final EObject newObject;
    private ECPSWTView ecpswtView;

    public CreateDialog(Shell parent, EObject createdInstance) {
        super(parent);
        this.newObject = createdInstance;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new " + this.newObject.eClass().getName());
        newShell.setMinimumSize(300, 150);
        newShell.setBackground(new Color((Device)newShell.getDisplay(), 255, 255, 255));
        newShell.setBackgroundMode(2);
    }

    protected Control createDialogArea(Composite parent) {
        GridData parentData = new GridData(4, 4, true, true);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)parentData);
        ScrolledComposite wrapper = new ScrolledComposite(parent, 512);
        wrapper.setExpandHorizontal(true);
        wrapper.setExpandVertical(true);
        FillLayout wrapperLayout = new FillLayout();
        wrapperLayout.marginHeight = 10;
        wrapperLayout.marginWidth = 10;
        wrapper.setLayout((Layout)wrapperLayout);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite emfFormsParent = new Composite((Composite)wrapper, 0);
        wrapper.setContent((Control)emfFormsParent);
        emfFormsParent.setLayout((Layout)new GridLayout());
        try {
            VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
            properties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
            this.ecpswtView = ECPSWTViewRenderer.INSTANCE.render(emfFormsParent, this.newObject, (VViewModelProperties)properties);
            ValidationService validationService = (ValidationService)this.ecpswtView.getViewModelContext().getService(ValidationService.class);
            validationService.registerValidationListener(new ViewValidationListener(){

                public void onNewValidation(Set<Diagnostic> validationResults) {
                    CreateDialog.this.updateOKButtonEnablement();
                }
            });
        }
        catch (ECPRendererException eCPRendererException) {
            // empty catch block
        }
        wrapper.setMinSize(wrapper.computeSize(-1, -1));
        return parent;
    }

    protected void okPressed() {
        this.getParentShell().forceFocus();
        Diagnostic result = Diagnostician.INSTANCE.validate(this.newObject);
        if (result.getSeverity() == 0) {
            super.okPressed();
        } else {
            int errorCount = result.getChildren().size();
            StringBuilder sb = new StringBuilder();
            sb.append(errorCount);
            sb.append(" ");
            sb.append(errorCount == 1 ? "error" : "errors");
            sb.append(" occured while analyzing your inputs. The following errors were found:\r\n");
            int messageCount = 1;
            for (Diagnostic d : result.getChildren()) {
                sb.append("\r\n");
                sb.append(messageCount++);
                sb.append(". ");
                sb.append(d.getMessage());
            }
            String errorMessage = sb.toString();
            MessageDialog.open((int)1, (Shell)this.getParentShell(), (String)"Error", (String)errorMessage, (int)0);
        }
    }

    public EObject getCreatedInstance() {
        return this.newObject;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOKButtonEnablement();
    }

    private void updateOKButtonEnablement() {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        if (this.ecpswtView.getViewModelContext().getViewModel().getDiagnostic().getHighestSeverity() >= 4) {
            button.setEnabled(false);
        } else {
            button.setEnabled(true);
        }
    }
}

