/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.reveal;

import java.util.Collections;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.internal.core.services.reveal.DeferredRevealStep;
import org.eclipse.emfforms.internal.core.services.reveal.DrillDownRevealStep;
import org.eclipse.emfforms.internal.core.services.reveal.EMFFormsRevealServiceImpl;
import org.eclipse.emfforms.internal.core.services.reveal.MasterDetailRevealStep;
import org.eclipse.emfforms.spi.core.services.reveal.DrillDown;
import org.eclipse.emfforms.spi.core.services.reveal.RevealHelper;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStep;

final class RevealHelperImpl
implements RevealHelper {
    private final EMFFormsRevealServiceImpl owner;
    private final VElement viewModel;
    private final EObject domainModel;
    private final EStructuralFeature feature;

    @Inject
    RevealHelperImpl(EMFFormsRevealServiceImpl owner, VElement viewModel, EObject domainModel) {
        this(owner, viewModel, domainModel, null);
    }

    @Inject
    RevealHelperImpl(EMFFormsRevealServiceImpl owner, VElement viewModel, EObject domainModel, EStructuralFeature feature) {
        this.owner = owner;
        this.viewModel = viewModel;
        this.domainModel = domainModel;
        this.feature = feature;
    }

    @Override
    public RevealStep drillDown(Object drillDownStep, Object childrenFunction) {
        Stream<VElement> children;
        if (childrenFunction == null) {
            children = this.viewModel.eContents().stream().filter(VElement.class::isInstance).map(VElement.class::cast);
        } else {
            Iterable evaluation = this.owner.evaluate(DrillDown.class, Iterable.class, this.viewModel, this.domainModel, this.feature, childrenFunction).orElse(Collections.emptyList());
            children = StreamSupport.stream(evaluation.spliterator(), false).filter(VElement.class::isInstance).map(VElement.class::cast);
        }
        return children.map(contained -> this.owner.reveal(this.domainModel, this.feature, (VElement)contained)).sorted(RevealStep.preferredOrdering()).findFirst().map(nextStep -> RevealStep.drillDown(this.viewModel, this.owner.getViewContext(this.viewModel).getDomainModel(), nextStep, () -> {
            boolean bl = this.owner.perform(new DrillDownRevealStep(this.owner, this.viewModel, this.domainModel, this.feature, (RevealStep)nextStep, drillDownStep));
        })).orElse(RevealStep.FAILED);
    }

    @Override
    public RevealStep defer(Object deferredStep) {
        return new DeferredRevealStep(this.owner, this.viewModel, this.domainModel, this.feature, deferredStep);
    }

    @Override
    public RevealStep masterDetail(Object masterStep, Object masterFunction) {
        return new MasterDetailRevealStep(this.owner, this.viewModel, this.domainModel, this.feature, masterFunction, masterStep);
    }
}

