/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.converter;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.spreadsheet.core.converter.XMIStringConverterHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="EMFFormsSpreadsheetMultiReferenceConverter")
public class EMFFormsSpreadsheetMultiReferenceConverter
implements EMFFormsSpreadsheetValueConverter {
    private static final String SEPARATOR = "\n\n\n";
    private EMFFormsDatabindingEMF databinding;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    public void setDatabinding(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public double isApplicable(EObject domainObject, VDomainModelReference dmr) {
        EStructuralFeature feature = EMFFormsSpreadsheetValueConverterHelper.getFeature(domainObject, dmr, this.databinding, this.reportService);
        if (feature == null) {
            return Double.NaN;
        }
        if (!EReference.class.isInstance(feature)) {
            return Double.NaN;
        }
        if (!feature.isMany()) {
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public void setCellValue(Cell cell, Object values, EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) throws EMFFormsConverterException {
        if (values == null) {
            return;
        }
        try {
            StringBuilder result = new StringBuilder();
            for (EObject value : (List)values) {
                if (result.length() != 0) {
                    result.append(SEPARATOR);
                }
                result.append(XMIStringConverterHelper.getSerializedEObject(value));
            }
            cell.setCellValue(result.toString());
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Text"));
        }
        catch (IOException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(ex, 4));
        }
    }

    @Override
    public Object getCellValue(Cell cell, EStructuralFeature eStructuralFeature) throws EMFFormsConverterException {
        String[] split;
        String string = cell.getStringCellValue();
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        String[] stringArray = split = string.split(SEPARATOR);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                result.add(XMIStringConverterHelper.deserializeObject(element.trim()));
            }
            catch (IOException ex) {
                throw new EMFFormsConverterException(MessageFormat.format("The cell value {0} could not be deserialized to a model value.", string));
            }
            ++n2;
        }
        return result;
    }
}

