/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import javax.inject.Inject;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.ExpectedValueControlRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.rule.RuleConditionDmrUtil;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LeafConditionSegmentControlRenderer
extends ExpectedValueControlRenderer {
    @Inject
    public LeafConditionSegmentControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF databindingService, EMFFormsLabelProvider labelProvider, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService, (EMFFormsDatabinding)databindingService, labelProvider, viewTemplateProvider);
    }

    @Override
    protected void onSelectButton(Label control) {
        EStructuralFeature structuralFeature;
        LeafCondition condition;
        try {
            condition = (LeafCondition)this.getObservedEObject();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        if (condition.getDomainModelReference() == null) {
            this.showError(control.getShell(), "No Domain Model Reference found", "A Domain Model Reference needs to be added to the condition first.");
            return;
        }
        try {
            EClass conditionRoot = RuleConditionDmrUtil.getDmrRootEClass((EMFFormsDatabindingEMF)this.getEMFFormsDatabinding(), (ReportService)this.getReportService(), (EObject)condition).orElse(null);
            IEMFValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(condition.getDomainModelReference(), conditionRoot);
            structuralFeature = valueProperty.getStructuralFeature();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        if (!EAttribute.class.isInstance(structuralFeature)) {
            this.showError(control.getShell(), "No EAttribute selected", "The condition's domain model reference must point to an EAttribute.");
            return;
        }
        if (condition.getValueDomainModelReference() != null) {
            this.showInfo(control.getShell(), "Legacy Value DMR will be removed", "The LeafCondition's Value DMR is deprecated with the usage of segments. This LeafCondition's value DMR is removed now. If you want to iterate over a multi reference, please use the Iterate Condition.");
            condition.setValueDomainModelReference(null);
        }
        Object object = this.getSelectedObject((EAttribute)structuralFeature);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)condition);
        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)condition, (Object)RulePackage.Literals.LEAF_CONDITION__EXPECTED_VALUE, (Object)object));
        if (object != null) {
            control.setText(object.toString());
        } else {
            control.setText("null");
        }
    }

    protected EMFFormsDatabindingEMF getEMFFormsDatabinding() {
        return (EMFFormsDatabindingEMF)super.getEMFFormsDatabinding();
    }

    protected void showInfo(Shell parent, String title, String message) {
        MessageDialog.openInformation((Shell)parent, (String)title, (String)message);
    }
}

