/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class RelativeFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private File rootFolder;

    public RelativeFileSelectionDialog(Shell parent, File rootFolder) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider());
        assert (rootFolder != null);
        this.setValidator(new SelectionValidator());
        this.setInput(rootFolder.getAbsolutePath());
        this.setTitle(Messages.getString("RelativeFileSelectionDialog.Title.SelectFile"));
        this.rootFolder = rootFolder;
    }

    public URI getSelectedURI() throws URISyntaxException {
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0 && selection[0] instanceof File) {
            URI baseURI = this.rootFolder.toURI();
            return baseURI.relativize(((File)selection[0]).toURI());
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.getTreeViewer().expandToLevel(2);
        return c;
    }

    private static File[] getChildren(File f) {
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] result = f.listFiles(new FileFilter(){

            public boolean accept(File child) {
                if (child.isDirectory()) {
                    return true;
                }
                return true;
            }
        });
        if (result != null) {
            Arrays.sort(result, new FileComparator());
        }
        return result == null ? new File[]{} : result;
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            if (f.isFile()) {
                URI relative = this.rootFolder.toURI().relativize(f.toURI());
                result.add(relative.getPath());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return RelativeFileSelectionDialog.getChildren(f);
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return RelativeFileSelectionDialog.getChildren(f).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{new File((String)arg0)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isFile() && o2.isFile()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            return 1;
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.isFile()) {
                    return IMG_FILE;
                }
                return IMG_FOLDER;
            }
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().equals("")) {
                    return f.getPath();
                }
                return f.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof File && ((File)o).isFile()) {
                        return new Status(0, "org.eclipse.datatools.connectivity.oda.flatfile.ui", 0, "", null);
                    }
                    ++n2;
                }
            }
            return new Status(4, "org.eclipse.datatools.connectivity.oda.flatfile.ui", 4, "", null);
        }
    }
}

