/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ui.internal.util.Util;

public final class CategoryDefinition
implements Comparable<CategoryDefinition> {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = CategoryDefinition.class.getName().hashCode();
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private String sourceId;
    private transient String string;
    private String description;

    static Map<String, CategoryDefinition> categoryDefinitionsById(Collection<CategoryDefinition> categoryDefinitions, boolean allowNullIds) {
        if (categoryDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, CategoryDefinition> map = new HashMap<String, CategoryDefinition>();
        for (CategoryDefinition categoryDefinition : categoryDefinitions) {
            String id = categoryDefinition.getId();
            if (!allowNullIds && id == null) continue;
            map.put(id, categoryDefinition);
        }
        return map;
    }

    static Map<String, Collection<CategoryDefinition>> categoryDefinitionsByName(Collection<CategoryDefinition> categoryDefinitions, boolean allowNullNames) {
        if (categoryDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, Collection<CategoryDefinition>> map = new HashMap<String, Collection<CategoryDefinition>>();
        for (CategoryDefinition categoryDefinition : categoryDefinitions) {
            String name = categoryDefinition.getName();
            if (!allowNullNames && name == null) continue;
            HashSet<CategoryDefinition> categoryDefinitions2 = (HashSet<CategoryDefinition>)map.get(name);
            if (categoryDefinitions2 == null) {
                categoryDefinitions2 = new HashSet<CategoryDefinition>();
                map.put(name, categoryDefinitions2);
            }
            categoryDefinitions2.add(categoryDefinition);
        }
        return map;
    }

    public CategoryDefinition(String id, String name, String sourceId, String description) {
        this.id = id;
        this.name = name;
        this.sourceId = sourceId;
        this.description = description;
    }

    @Override
    public int compareTo(CategoryDefinition object) {
        int compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)object.id));
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)object.name))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)object.sourceId));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoryDefinition)) {
            return false;
        }
        CategoryDefinition castedObject = (CategoryDefinition)object;
        return Objects.equals(this.id, castedObject.id) && Objects.equals(this.name, castedObject.name) && Objects.equals(this.sourceId, castedObject.sourceId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getDescription() {
        return this.description;
    }
}

