/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;

public abstract class SpecificLaunchListener
implements ILaunchesListener2 {
    private final ILaunchConfiguration config;

    public SpecificLaunchListener(ILaunchConfiguration config) {
        this.config = config;
    }

    private boolean matches(ILaunch launch) {
        if (launch == null || launch.getLaunchConfiguration() == null) {
            return false;
        }
        return launch.getLaunchConfiguration().contentsEqual(this.config);
    }

    private void runIfMatches(ILaunch[] launches, ILaunchMethod handle) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (this.matches(l)) {
                handle.theMethod(l);
            }
            ++n2;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.runIfMatches(launches, this::launchRemoved);
    }

    public void launchesAdded(ILaunch[] launches) {
        this.runIfMatches(launches, this::launchAdded);
    }

    public void launchesChanged(ILaunch[] launches) {
        this.runIfMatches(launches, this::launchChanged);
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.runIfMatches(launches, this::launchTerminated);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchTerminated(ILaunch launch) {
    }

    private static interface ILaunchMethod {
        public void theMethod(ILaunch var1);
    }
}

