/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContext;
import org.eclipse.pde.internal.ds.ui.editor.DSLabelProvider;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.dialogs.DSEditReferenceDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSReferenceSection
extends TableSection
implements IDoubleClickListener {
    private TableViewer fReferencesTable;
    private Action fRemoveAction;
    private Action fAddAction;
    private Action fEditAction;

    public DSReferenceSection(PDEFormPage page, Composite parent) {
        super(page, parent, 130, new String[]{Messages.DSReferenceSection_add, Messages.DSReferenceSection_remove, Messages.DSReferenceSection_edit, Messages.DSReferenceSection_up, Messages.DSReferenceSection_down});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setDescription(Messages.DSReferenceSection_description);
        section.setExpanded(true);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fReferencesTable = tablePart.getTableViewer();
        this.fReferencesTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fReferencesTable.setLabelProvider((IBaseLabelProvider)new ReferenceLabelProvider());
        this.fReferencesTable.addDoubleClickListener((IDoubleClickListener)this);
        this.makeActions();
        IDSModel model = this.getDSModel();
        if (model != null) {
            this.fReferencesTable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.updateTitle();
    }

    public void dispose() {
        IDSModel model = this.getDSModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public void refresh() {
        this.fReferencesTable.refresh();
        this.updateButtons();
        this.updateTitle();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleEdit();
                break;
            }
            case 3: {
                this.handleMove(true);
                break;
            }
            case 4: {
                this.handleMove(false);
            }
        }
    }

    private void handleMove(boolean moveUp) {
        IStructuredSelection selection = this.fReferencesTable.getStructuredSelection();
        Object[] array = selection.toArray();
        if (moveUp) {
            this.moveUp(array);
        } else {
            this.moveDown(array);
        }
    }

    private void moveDown(Object[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            Object object = array[i];
            if (object != null && object instanceof IDocumentElementNode) {
                this.getDSModel().getDSComponent().moveChildNode((IDocumentElementNode)object, 1, true);
            }
            --i;
        }
    }

    private void moveUp(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null && object instanceof IDocumentElementNode) {
                this.getDSModel().getDSComponent().moveChildNode((IDocumentElementNode)object, -1, true);
            }
            ++n2;
        }
    }

    private void handleEdit() {
        int selectionIndex = this.fReferencesTable.getTable().getSelectionIndex();
        if (selectionIndex != -1) {
            DSEditReferenceDialog dialog = new DSEditReferenceDialog(Activator.getActiveWorkbenchShell(), (IDSReference)this.fReferencesTable.getElementAt(selectionIndex), this);
            dialog.create();
            dialog.getShell().setSize(500, 400);
            dialog.open();
        }
    }

    private void makeActions() {
        this.fAddAction = new Action(Messages.DSReferenceSection_add){

            public void run() {
                DSReferenceSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(Messages.DSReferenceSection_remove){

            public void run() {
                DSReferenceSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fEditAction = new Action(Messages.DSReferenceSection_edit){

            public void run() {
                DSReferenceSection.this.handleEdit();
            }
        };
        this.fEditAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fReferencesTable.getTable();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        int length = table.getSelection().length;
        tablePart.setButtonEnabled(1, this.isEditable() && length > 0);
        tablePart.setButtonEnabled(2, this.isEditable() && length > 0);
        tablePart.setButtonEnabled(3, this.isEditable() && table.getSelection().length > 0 && !table.isSelected(0));
        tablePart.setButtonEnabled(4, this.isEditable() && table.getSelection().length > 0 && !table.isSelected(table.getItems().length - 1));
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fReferencesTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            for (Object object : ssel) {
                if (!(object instanceof IDSReference)) continue;
                this.getDSModel().getDSComponent().removeReference((IDSReference)object);
            }
        }
    }

    private void handleAdd() {
        this.doOpenSelectionDialog(512);
    }

    private void doOpenSelectionDialog(int scopeType) {
        try {
            String filter = "";
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)true, (String)filter);
            dialog.setTitle(Messages.DSReferenceDetails_selectType);
            if (dialog.open() == 0) {
                Object[] result;
                Object[] objectArray = result = dialog.getResult();
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    IType type = (IType)element;
                    String fullyQualifiedName = type.getFullyQualifiedName('$');
                    this.addReference(fullyQualifiedName);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void addReference(String fullyQualifiedName) {
        IDSReference reference = this.getDSModel().getFactory().createReference();
        reference.setReferenceInterface(fullyQualifiedName);
        int index = fullyQualifiedName.lastIndexOf(".");
        if (index != -1) {
            fullyQualifiedName = fullyQualifiedName.substring(index + 1);
        }
        reference.setReferenceName(fullyQualifiedName);
        this.getDSModel().getDSComponent().addReference(reference);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects;
            Object[] objectArray = objects = e.getChangedObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Table table = this.fReferencesTable.getTable();
                if (object instanceof IDSReference) {
                    int index = table.getSelectionIndex();
                    this.fReferencesTable.remove(object);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++n2;
            }
            this.updateButtons();
            this.updateTitle();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fReferencesTable.refresh();
                this.fReferencesTable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
            this.updateTitle();
        } else {
            this.fReferencesTable.refresh();
            this.updateButtons();
        }
    }

    private DSInputContext getDSContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (DSInputContext)manager.findContext("ds-context");
    }

    private IDSModel getDSModel() {
        DSInputContext context = this.getDSContext();
        return context == null ? null : (IDSModel)context.getModel();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    private void updateTitle() {
        int itemCount = this.fReferencesTable.getTable().getItemCount();
        this.getSection().setText(NLS.bind((String)Messages.DSReferenceSection_title, (Object)itemCount));
    }

    public void doubleClick(DoubleClickEvent event) {
        IDSReference reference = (IDSReference)this.fReferencesTable.getStructuredSelection().getFirstElement();
        String value = reference.getReferenceInterface();
        IProject project = this.getProject();
        try {
            IJavaProject javaProject;
            IType element;
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature") && (element = (javaProject = JavaCore.create((IProject)project)).findType(value.replace('$', '.'))) != null) {
                JavaUI.openInEditor((IJavaElement)element);
            }
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDSModel model;
            IDSComponent component;
            if (inputElement instanceof IDSModel && (component = (model = (IDSModel)inputElement).getDSComponent()) != null) {
                return component.getReferences();
            }
            return new Object[0];
        }
    }

    class ReferenceLabelProvider
    extends StyledCellLabelProvider {
        private DSLabelProvider labelProvider = new DSLabelProvider();

        ReferenceLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            IDSReference reference = (IDSReference)element;
            String name = reference.getReferenceName();
            if (name == null || name.length() == 0) {
                name = reference.getReferenceInterface();
            }
            if (name == null) {
                name = "";
            }
            StyledString styledString = new StyledString(name);
            String bind = reference.getReferenceBind();
            String unbind = reference.getReferenceUnbind();
            bind = bind == null || bind.length() == 0 ? "<none>" : bind;
            unbind = unbind == null || unbind.length() == 0 ? "<none>" : unbind;
            styledString.append(" [" + bind + "," + unbind + "]", StyledString.DECORATIONS_STYLER);
            String target = reference.getReferenceTarget();
            if (target != null) {
                styledString.append(" " + target, StyledString.QUALIFIER_STYLER);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.labelProvider.getImage(reference));
            super.update(cell);
        }

        public void dispose() {
            super.dispose();
            this.labelProvider.dispose();
        }
    }
}

