/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.util.Internal;

public class HemfGraphics
extends HwmfGraphics {
    private static final HwmfColorRef WHITE = new HwmfColorRef(Color.WHITE);
    private static final HwmfColorRef LTGRAY = new HwmfColorRef(new Color(0xC0C0C0));
    private static final HwmfColorRef GRAY = new HwmfColorRef(new Color(0x808080));
    private static final HwmfColorRef DKGRAY = new HwmfColorRef(new Color(0x404040));
    private static final HwmfColorRef BLACK = new HwmfColorRef(Color.BLACK);

    public HemfGraphics(Graphics2D graphicsCtx, Rectangle2D bbox) {
        super(graphicsCtx, bbox);
        this.objectIndexes.set(0);
    }

    @Override
    public HemfDrawProperties getProperties() {
        return (HemfDrawProperties)super.getProperties();
    }

    @Override
    protected HemfDrawProperties newProperties(HwmfDrawProperties oldProps) {
        return oldProps == null ? new HemfDrawProperties() : new HemfDrawProperties((HemfDrawProperties)oldProps);
    }

    public void draw(HemfRecord r) {
        r.draw(this);
    }

    @Internal
    public void draw(Consumer<Path2D> pathConsumer, HwmfGraphics.FillDrawStyle fillDraw) {
        Path2D path;
        HemfDrawProperties prop = this.getProperties();
        boolean useBracket = prop.getUsePathBracket();
        if (useBracket) {
            path = prop.getPath();
        } else {
            path = new Path2D.Double();
            path.setWindingRule(prop.getWindingRule());
        }
        if (path.getCurrentPoint() == null) {
            Point2D pnt = prop.getLocation();
            path.moveTo(pnt.getX(), pnt.getY());
        }
        try {
            pathConsumer.accept(path);
        }
        catch (Exception e) {
            Point2D loc = prop.getLocation();
            path.moveTo(loc.getX(), loc.getY());
            pathConsumer.accept(path);
        }
        Point2D curPnt = path.getCurrentPoint();
        if (curPnt == null) {
            return;
        }
        prop.setLocation(curPnt);
        if (!useBracket) {
            switch (fillDraw) {
                case FILL: {
                    super.fill(path);
                    break;
                }
                case DRAW: {
                    super.draw(path);
                    break;
                }
                case FILL_DRAW: {
                    super.fill(path);
                    super.draw(path);
                }
            }
        }
    }

    public void addObjectTableEntry(HwmfObjectTableEntry entry, int index) {
        if (index < 1) {
            throw new IndexOutOfBoundsException("Object table entry index in EMF must be > 0 - invalid index: " + index);
        }
        this.objectIndexes.set(index);
        this.objectTable.put(index, entry);
    }

    @Override
    public void applyObjectTableEntry(int index) {
        if ((index & Integer.MIN_VALUE) != 0) {
            this.selectStockObject(index);
        } else {
            super.applyObjectTableEntry(index);
        }
    }

    private void selectStockObject(int objectIndex) {
        HemfDrawProperties prop = this.getProperties();
        switch (objectIndex) {
            case -2147483648: {
                prop.setBrushColor(WHITE);
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                break;
            }
            case -2147483647: {
                prop.setBrushColor(LTGRAY);
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                break;
            }
            case -2147483646: {
                prop.setBrushColor(GRAY);
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                break;
            }
            case -2147483645: {
                prop.setBrushColor(DKGRAY);
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                break;
            }
            case -2147483644: {
                prop.setBrushColor(BLACK);
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                break;
            }
            case -2147483643: {
                prop.setBrushStyle(HwmfBrushStyle.BS_NULL);
                break;
            }
            case -2147483642: {
                prop.setPenStyle(HwmfPenStyle.valueOf(0));
                prop.setPenWidth(1.0);
                prop.setPenColor(WHITE);
                break;
            }
            case -2147483641: {
                prop.setPenStyle(HwmfPenStyle.valueOf(0));
                prop.setPenWidth(1.0);
                prop.setPenColor(BLACK);
                break;
            }
            case -2147483640: {
                prop.setPenStyle(HwmfPenStyle.valueOf(HwmfPenStyle.HwmfLineDash.NULL.wmfFlag));
                break;
            }
            case -2147483638: {
                break;
            }
            case -2147483637: {
                break;
            }
            case -2147483636: {
                break;
            }
            case -2147483635: {
                break;
            }
            case -2147483634: {
                break;
            }
            case -2147483633: {
                break;
            }
            case -2147483632: {
                break;
            }
            case -2147483631: {
                break;
            }
            case -2147483630: {
                break;
            }
        }
    }
}

