/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.DFA;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnwantedTokenException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.NodeModelBuilder;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.parser.antlr.TokenTool;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.service.AllRulesCache;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractInternalAntlrParser
extends Parser {
    private static final Class<?>[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static final Logger logger = Logger.getLogger(AbstractInternalAntlrParser.class);
    private ICompositeNode currentNode;
    private INode lastConsumedNode;
    private boolean hadErrors;
    private IAstFactory semanticModelBuilder;
    private int lastConsumedIndex = -1;
    private Map<String, AbstractRule> allRules;
    private ISyntaxErrorMessageProvider syntaxErrorProvider;
    private IUnorderedGroupHelper unorderedGroupHelper;
    private NodeModelBuilder nodeBuilder = new NodeModelBuilder();
    private Map<Integer, String> antlrTypeToLexerName = null;
    private String[] readableTokenNames = null;
    private SyntaxErrorMessage currentError = null;

    protected AbstractInternalAntlrParser(TokenStream input) {
        super(input);
    }

    protected AbstractInternalAntlrParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    protected void registerRules(Grammar grammar) {
        this.allRules = this.createAllRules(grammar);
    }

    protected Map<String, AbstractRule> createAllRules(Grammar grammar) {
        AllRulesCache cache = AllRulesCache.findInEmfObject((Notifier)grammar);
        if (cache != null) {
            return cache.getAllRules();
        }
        HashMap allRules = Maps.newHashMap();
        for (AbstractRule rule : GrammarUtil.allRules(grammar)) {
            if (rule instanceof TerminalRule) {
                allRules.put(rule.getName().toUpperCase(), rule);
                continue;
            }
            allRules.put(rule.getName(), rule);
        }
        return allRules;
    }

    public TokenStream getInput() {
        return this.input;
    }

    protected ICompositeNode getCurrentNode() {
        return this.currentNode;
    }

    protected abstract IGrammarAccess getGrammarAccess();

    protected void associateNodeWithAstElement(ICompositeNode node, EObject astElement) {
        if (astElement == null) {
            throw new NullPointerException("passed astElement was null");
        }
        if (node == null) {
            throw new NullPointerException("passed node was null");
        }
        this.nodeBuilder.associateWithSemanticElement(node, astElement);
    }

    private ILeafNode createLeafNode(Token token, EObject grammarElement) {
        boolean isHidden = token.getChannel() == 99;
        SyntaxErrorMessage error = null;
        if (!isHidden && this.currentError != null) {
            error = this.currentError;
            this.currentError = null;
        }
        if (token.getType() == 0 && error == null) {
            String lexerErrorMessage = ((XtextTokenStream)this.input).getLexerErrorMessage(token);
            LexerErrorContext errorContext = new LexerErrorContext(lexerErrorMessage);
            error = this.syntaxErrorProvider.getSyntaxErrorMessage(errorContext);
        }
        if (grammarElement == null) {
            String ruleName = this.antlrTypeToLexerName.get(token.getType());
            grammarElement = this.allRules.get(ruleName);
        }
        CommonToken commonToken = (CommonToken)token;
        if (error != null) {
            this.hadErrors = true;
        }
        return this.nodeBuilder.newLeafNode(commonToken.getStartIndex(), commonToken.getStopIndex() - commonToken.getStartIndex() + 1, grammarElement, isHidden, error, this.currentNode);
    }

    public void setTokenTypeMap(Map<Integer, String> tokenTypeMap) {
        this.antlrTypeToLexerName = Maps.newHashMap();
        for (Map.Entry<Integer, String> mapEntry : tokenTypeMap.entrySet()) {
            String value = mapEntry.getValue();
            if (!TokenTool.isLexerRule(value)) continue;
            this.antlrTypeToLexerName.put(mapEntry.getKey(), TokenTool.getLexerRuleName(value));
        }
        String[] tokenNames = this.getTokenNames();
        this.readableTokenNames = new String[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
            this.readableTokenNames[i] = tokenTypeMap.containsKey(i) ? tokenTypeMap.get(i) : tokenNames[i];
        }
    }

    public void setSyntaxErrorProvider(ISyntaxErrorMessageProvider syntaxErrorProvider) {
        this.syntaxErrorProvider = syntaxErrorProvider;
    }

    public ISyntaxErrorMessageProvider getSyntaxErrorProvider() {
        return this.syntaxErrorProvider;
    }

    protected void set(EObject _this, String feature, Object value, String lexerRule, INode node) {
        try {
            this.semanticModelBuilder.set(_this, feature, value, lexerRule, node);
        }
        catch (ValueConverterException vce) {
            this.handleValueConverterException(vce);
        }
    }

    protected void set(EObject _this, String feature, Object value, String lexerRule) {
        if (value != null) {
            this.set(_this, feature, value, lexerRule, this.currentNode);
        }
    }

    protected void set(EObject _this, String feature, boolean value, String lexerRule) {
        if (value) {
            this.set(_this, feature, value, lexerRule, this.currentNode);
        }
    }

    protected void setWithLastConsumed(EObject _this, String feature, Object value, String lexerRule) {
        if (value != null) {
            this.set(_this, feature, value, lexerRule, this.lastConsumedNode);
        }
    }

    protected void setWithLastConsumed(EObject _this, String feature, boolean value, String lexerRule) {
        if (value) {
            this.set(_this, feature, value, lexerRule, this.lastConsumedNode);
        }
    }

    protected void add(EObject _this, String feature, Object value, String lexerRule, INode node) {
        try {
            this.semanticModelBuilder.add(_this, feature, value, lexerRule, node);
        }
        catch (ValueConverterException vce) {
            this.handleValueConverterException(vce);
        }
    }

    protected void add(EObject _this, String feature, Object value, String lexerRule) {
        if (value != null) {
            this.add(_this, feature, value, lexerRule, this.currentNode);
        }
    }

    protected void add(EObject _this, String feature, boolean value, String lexerRule) {
        if (value) {
            this.add(_this, feature, value, lexerRule, this.currentNode);
        }
    }

    protected void addWithLastConsumed(EObject _this, String feature, Object value, String lexerRule) {
        if (value != null) {
            this.add(_this, feature, value, lexerRule, this.lastConsumedNode);
        }
    }

    protected void addWithLastConsumed(EObject _this, String feature, boolean value, String lexerRule) {
        if (value) {
            this.add(_this, feature, value, lexerRule, this.lastConsumedNode);
        }
    }

    protected void appendError(INode node) {
        if (this.currentError != null && node.getSyntaxErrorMessage() == null) {
            INode newNode = this.nodeBuilder.setSyntaxError(node, this.currentError);
            if (node == this.currentNode) {
                this.currentNode = (ICompositeNode)newNode;
            }
            this.currentError = null;
        }
    }

    protected void appendAllTokens() {
        for (int x = this.lastConsumedIndex + 1; this.input.size() > x; ++x) {
            Token hidden = this.input.get(x);
            this.createLeafNode(hidden, null);
            this.lastConsumedIndex = hidden.getTokenIndex();
            this.input.consume();
        }
        if (this.currentError != null) {
            this.appendError(this.getLastLeafNode());
        }
    }

    protected INode getLastLeafNode() {
        BidiIterator iter = this.currentNode.getAsTreeIterable().iterator();
        while (iter.hasPrevious()) {
            INode previous = (INode)iter.previous();
            if (!(previous instanceof ILeafNode)) continue;
            return previous;
        }
        return this.currentNode;
    }

    protected List<ILeafNode> appendSkippedTokens() {
        int indexOfTokenBefore;
        ArrayList<ILeafNode> skipped = new ArrayList<ILeafNode>();
        Token currentToken = this.input.LT(-1);
        int currentTokenIndex = currentToken == null ? -1 : currentToken.getTokenIndex();
        Token tokenBefore = this.lastConsumedIndex == -1 ? null : this.input.get(this.lastConsumedIndex);
        int n = indexOfTokenBefore = tokenBefore != null ? tokenBefore.getTokenIndex() : -1;
        if (indexOfTokenBefore + 1 < currentTokenIndex) {
            int x = indexOfTokenBefore + 1;
            while (x < currentTokenIndex) {
                Token hidden = this.input.get(x);
                ILeafNode leaf = this.createLeafNode(hidden, null);
                skipped.add(leaf);
                this.lastConsumedIndex = x++;
            }
        }
        if (this.lastConsumedIndex < currentTokenIndex && currentToken != null) {
            ILeafNode leaf = this.createLeafNode(currentToken, null);
            skipped.add(leaf);
            this.lastConsumedIndex = currentToken.getTokenIndex();
        }
        return skipped;
    }

    protected void appendTrailingHiddenTokens() {
        Token tokenBefore = this.input.LT(-1);
        int size = this.input.size();
        if (tokenBefore != null && tokenBefore.getTokenIndex() < size) {
            for (int x = tokenBefore.getTokenIndex() + 1; x < size; ++x) {
                Token hidden = this.input.get(x);
                this.createLeafNode(hidden, null);
                this.lastConsumedIndex = hidden.getTokenIndex();
            }
        }
    }

    public void recover(IntStream input, RecognitionException re) {
        if (this.currentError == null) {
            this.currentError = this.getSyntaxErrorMessage(re, this.getTokenNames());
        }
        super.recover(input, re);
    }

    protected String getValueConverterExceptionMessage(ValueConverterException vce) {
        String result;
        Exception cause = (Exception)vce.getCause();
        String string = result = cause != null ? cause.getMessage() : vce.getMessage();
        if (result == null) {
            result = vce.getMessage();
        }
        if (result == null) {
            result = cause != null ? cause.getClass().getSimpleName() : vce.getClass().getSimpleName();
        }
        return result;
    }

    protected void handleValueConverterException(ValueConverterException vce) {
        this.hadErrors = true;
        Exception cause = (Exception)vce.getCause();
        if (vce != cause) {
            ISyntaxErrorMessageProvider.IValueConverterErrorContext errorContext = this.createValueConverterErrorContext(vce);
            this.currentError = this.syntaxErrorProvider.getSyntaxErrorMessage(errorContext);
            if (vce.getNode() == null) {
                this.appendError(this.currentNode.getLastChild());
            } else {
                this.appendError(vce.getNode());
            }
        } else {
            throw new RuntimeException(vce);
        }
    }

    protected ISyntaxErrorMessageProvider.IValueConverterErrorContext createValueConverterErrorContext(ValueConverterException vce) {
        return new ValueConverterErrorContext(vce);
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        throw new UnsupportedOperationException("getErrorMessage");
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        throw new UnsupportedOperationException("displayRecognitionError");
    }

    public void reportError(RecognitionException e) {
        if (this.state.errorRecovery) {
            return;
        }
        ++this.state.syntaxErrors;
        this.state.errorRecovery = true;
        if (this.currentError == null) {
            this.currentError = this.getSyntaxErrorMessage(e, this.getTokenNames());
        }
    }

    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        UnwantedTokenException e = null;
        if (this.mismatchIsUnwantedToken(input, ttype)) {
            e = new UnwantedTokenException(ttype, input);
            this.beginResync();
            input.consume();
            this.endResync();
            this.reportError((RecognitionException)e);
            Object matchedSymbol = this.getCurrentInputSymbol(input);
            input.consume();
            return matchedSymbol;
        }
        if (this.mismatchIsMissingToken(input, follow)) {
            Object inserted = this.getMissingSymbol(input, (RecognitionException)e, ttype, follow);
            e = new MissingTokenException(ttype, input, inserted);
            this.reportError((RecognitionException)e);
            return null;
        }
        e = new MismatchedTokenException(ttype, input);
        throw e;
    }

    public SyntaxErrorMessage getSyntaxErrorMessage(RecognitionException e, String[] tokenNames) {
        this.hadErrors = true;
        ISyntaxErrorMessageProvider.IParserErrorContext parseErrorContext = this.createErrorContext(e);
        return this.syntaxErrorProvider.getSyntaxErrorMessage(parseErrorContext);
    }

    protected String superGetErrorMessage(RecognitionException e, String[] tokenNames) {
        return super.getErrorMessage(e, tokenNames);
    }

    protected ISyntaxErrorMessageProvider.IParserErrorContext createErrorContext(RecognitionException e) {
        if (e instanceof FailedPredicateException) {
            return new UnorderedGroupErrorContext((FailedPredicateException)e);
        }
        return new ParserErrorContext(e);
    }

    public final IParseResult parse() throws RecognitionException {
        return this.parse(this.getFirstRuleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IParseResult parse(String entryRuleName) throws RecognitionException {
        long time = System.currentTimeMillis();
        ParseResult result = null;
        EObject current = null;
        String completeContent = this.input.toString();
        if (completeContent == null) {
            completeContent = "";
        }
        this.currentNode = this.nodeBuilder.newRootNode(completeContent);
        String antlrEntryRuleName = this.normalizeEntryRuleName(entryRuleName);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(antlrEntryRuleName, new Class[0]);
            method.setAccessible(true);
            Object parseResult = method.invoke((Object)this, new Object[0]);
            if (parseResult instanceof EObject) {
                current = (EObject)parseResult;
            }
            this.appendSkippedTokens();
            this.appendTrailingHiddenTokens();
            try {
                this.appendAllTokens();
            }
            finally {
                ICompositeNode root = this.nodeBuilder.compressAndReturnParent(this.currentNode);
                result = new ParseResult(current, root, this.hadErrors);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            if (targetException instanceof RecognitionException) {
                try {
                    this.appendAllTokens();
                }
                finally {
                    ICompositeNode root = this.nodeBuilder.compressAndReturnParent(this.currentNode);
                    result = new ParseResult(current, root, this.hadErrors);
                }
                throw (RecognitionException)targetException;
            }
            if (targetException instanceof Exception) {
                throw new WrappedException((Exception)targetException);
            }
            throw new RuntimeException(targetException);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parsing took: " + (System.currentTimeMillis() - time) + " ms"));
            }
        }
        return result;
    }

    private String normalizeEntryRuleName(String entryRuleName) {
        String antlrEntryRuleName = !entryRuleName.startsWith("entryRule") && !entryRuleName.startsWith("entryNorm") ? (!entryRuleName.startsWith("rule") ? "entryRule" + entryRuleName : "entry" + Strings.toFirstUpper((String)entryRuleName)) : entryRuleName;
        return antlrEntryRuleName;
    }

    public void emitErrorMessage(String msg) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)msg);
        }
    }

    protected abstract String getFirstRuleName();

    public void setUnorderedGroupHelper(IUnorderedGroupHelper unorderedGroupHelper) {
        this.unorderedGroupHelper = unorderedGroupHelper;
    }

    public IUnorderedGroupHelper getUnorderedGroupHelper() {
        return this.unorderedGroupHelper;
    }

    protected void afterParserOrEnumRuleCall() {
        ICompositeNode newCurrent = this.nodeBuilder.compressAndReturnParent(this.currentNode);
        if (this.currentNode == this.lastConsumedNode) {
            this.lastConsumedNode = newCurrent;
        }
        this.currentNode = newCurrent;
    }

    protected EObject createModelElementForParent(AbstractRule rule) {
        return this.createModelElement(rule.getType().getClassifier(), this.currentNode.getParent());
    }

    protected EObject createModelElement(AbstractRule rule) {
        return this.createModelElement(rule.getType().getClassifier(), this.currentNode);
    }

    protected EObject createModelElementForParent(EClassifier classifier) {
        return this.createModelElement(classifier, this.currentNode.getParent());
    }

    protected EObject createModelElement(EClassifier classifier) {
        return this.createModelElement(classifier, this.currentNode);
    }

    protected EObject createModelElement(EClassifier classifier, ICompositeNode compositeNode) {
        EObject result = this.semanticModelBuilder.create(classifier);
        this.associateNodeWithAstElement(compositeNode, result);
        return result;
    }

    protected EObject forceCreateModelElementAndSet(Action action, EObject value) {
        EObject result = this.semanticModelBuilder.create(action.getType().getClassifier());
        this.semanticModelBuilder.set(result, action.getFeature(), value, null, this.currentNode);
        this.insertCompositeNode(action);
        this.associateNodeWithAstElement(this.currentNode, result);
        return result;
    }

    protected EObject forceCreateModelElementAndAdd(Action action, EObject value) {
        EObject result = this.semanticModelBuilder.create(action.getType().getClassifier());
        this.semanticModelBuilder.add(result, action.getFeature(), value, null, this.currentNode);
        this.insertCompositeNode(action);
        this.associateNodeWithAstElement(this.currentNode, result);
        return result;
    }

    protected EObject forceCreateModelElement(Action action, EObject value) {
        EObject result = this.semanticModelBuilder.create(action.getType().getClassifier());
        this.insertCompositeNode(action);
        this.associateNodeWithAstElement(this.currentNode, result);
        return result;
    }

    protected void insertCompositeNode(Action action) {
        ICompositeNode newCurrentNode;
        this.currentNode = newCurrentNode = this.nodeBuilder.newCompositeNodeAsParentOf(action, this.currentNode.getLookAhead(), this.currentNode);
    }

    protected void enterRule() {
    }

    protected void leaveRule() {
        this.lastConsumedNode = this.currentNode;
    }

    protected void newCompositeNode(EObject grammarElement) {
        XtextTokenStream input = (XtextTokenStream)this.input;
        int lookAhead = input.getCurrentLookAhead();
        this.currentNode = this.nodeBuilder.newCompositeNode(grammarElement, lookAhead, this.currentNode);
    }

    protected void newLeafNode(Token token, EObject grammarElement) {
        if (token == null) {
            return;
        }
        int tokenIndex = token.getTokenIndex();
        if (tokenIndex > this.lastConsumedIndex) {
            for (int x = this.lastConsumedIndex + 1; x < tokenIndex; ++x) {
                Token hidden = this.input.get(x);
                this.createLeafNode(hidden, null);
            }
            this.lastConsumedIndex = tokenIndex;
            this.lastConsumedNode = this.createLeafNode(token, grammarElement);
        }
    }

    public void setNodeModelBuilder(NodeModelBuilder nodeModelBuilder) {
        this.nodeBuilder = nodeModelBuilder;
    }

    public NodeModelBuilder getNodeModelBuilder() {
        return this.nodeBuilder;
    }

    public void setSemanticModelBuilder(IAstFactory semanticModelBuilder) {
        this.semanticModelBuilder = semanticModelBuilder;
    }

    public IAstFactory getSemanticModelBuilder() {
        return this.semanticModelBuilder;
    }

    protected static short[][] unpackEncodedStringArray(String[] arr) {
        int numStates = arr.length;
        short[][] result = new short[numStates][];
        for (int i = 0; i < numStates; ++i) {
            result[i] = DFA.unpackEncodedString((String)arr[i]);
        }
        return result;
    }

    protected class ValueConverterErrorContext
    extends ErrorContext
    implements ISyntaxErrorMessageProvider.IValueConverterErrorContext {
        private final ValueConverterException valueConverterException;

        protected ValueConverterErrorContext(ValueConverterException valueConverterException) {
            this.valueConverterException = valueConverterException;
        }

        @Override
        public String getDefaultMessage() {
            return AbstractInternalAntlrParser.this.getValueConverterExceptionMessage(this.getValueConverterException());
        }

        @Override
        public ValueConverterException getValueConverterException() {
            return this.valueConverterException;
        }
    }

    protected class UnorderedGroupErrorContext
    extends ParserErrorContext
    implements ISyntaxErrorMessageProvider.IUnorderedGroupErrorContext {
        private List<AbstractElement> missingMandatoryElements;

        protected UnorderedGroupErrorContext(FailedPredicateException exception) {
            super((RecognitionException)exception);
        }

        @Override
        public FailedPredicateException getRecognitionException() {
            return (FailedPredicateException)super.getRecognitionException();
        }

        @Override
        public List<AbstractElement> getMissingMandatoryElements() {
            ImmutableList result = this.missingMandatoryElements;
            if (result == null) {
                String predicate = this.getRecognitionException().toString();
                int idx = predicate.indexOf("grammarAccess");
                int lastIdx = predicate.lastIndexOf(40);
                predicate = predicate.substring(idx + "grammarAccess.".length(), lastIdx);
                String ruleMethodGetter = predicate.substring(0, predicate.indexOf(40));
                String elementGetter = predicate.substring(predicate.indexOf(46) + 1);
                IGrammarAccess grammarAccess = AbstractInternalAntlrParser.this.getGrammarAccess();
                Object ruleAccess = this.invokeNoArgMethod(ruleMethodGetter, grammarAccess);
                UnorderedGroup group = (UnorderedGroup)this.invokeNoArgMethod(elementGetter, ruleAccess);
                ArrayList missingElements = Lists.newArrayList();
                for (int i = 0; i < group.getElements().size(); ++i) {
                    AbstractElement element = (AbstractElement)group.getElements().get(i);
                    if (GrammarUtil.isOptionalCardinality(element) || !AbstractInternalAntlrParser.this.unorderedGroupHelper.canSelect(group, i)) continue;
                    missingElements.add(element);
                }
                this.missingMandatoryElements = result = ImmutableList.copyOf((Collection)missingElements);
            }
            return result;
        }

        private Object invokeNoArgMethod(String name, Object target) {
            try {
                Method method = target.getClass().getMethod(name, emptyClassArray);
                return method.invoke(target, emptyObjectArray);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class LexerErrorContext
    extends ErrorContext
    implements ISyntaxErrorMessageProvider.IParserErrorContext {
        private String message;

        public LexerErrorContext(String message) {
            this.message = message;
        }

        @Override
        public String getDefaultMessage() {
            return this.message;
        }

        @Override
        public RecognitionException getRecognitionException() {
            return null;
        }

        @Override
        public String[] getTokenNames() {
            return AbstractInternalAntlrParser.this.readableTokenNames;
        }
    }

    protected class ParserErrorContext
    extends ErrorContext
    implements ISyntaxErrorMessageProvider.IParserErrorContext {
        private final RecognitionException recognitionException;

        protected ParserErrorContext(RecognitionException recognitionException) {
            this.recognitionException = recognitionException;
        }

        @Override
        public String getDefaultMessage() {
            return AbstractInternalAntlrParser.this.superGetErrorMessage(this.getRecognitionException(), this.getTokenNames());
        }

        @Override
        public RecognitionException getRecognitionException() {
            return this.recognitionException;
        }

        @Override
        public String[] getTokenNames() {
            return AbstractInternalAntlrParser.this.readableTokenNames;
        }
    }

    protected class ErrorContext {
        protected ErrorContext() {
        }

        public EObject getCurrentContext() {
            if (AbstractInternalAntlrParser.this.currentNode != null) {
                return AbstractInternalAntlrParser.this.currentNode.getSemanticElement();
            }
            return null;
        }

        public INode getCurrentNode() {
            return AbstractInternalAntlrParser.this.currentNode;
        }
    }
}

