/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.apt.core.internal.AptPlugin;

public class JarClassLoader
extends ClassLoader {
    private List<JarFile> _jars;
    private final LinkedHashSet<File> _files;
    private List<JarCLInputStream> _openStreams = new LinkedList<JarCLInputStream>();
    private boolean _open = true;

    public JarClassLoader(List<File> jarFiles, ClassLoader parent) {
        super(parent);
        this._files = new LinkedHashSet<File>(jarFiles);
        for (File f : jarFiles) {
            JarClassLoader._recursiveGetManifestJars(f, this._files);
        }
        this.open();
    }

    private void open() {
        this._jars = new ArrayList<JarFile>(this._files.size());
        for (File f : this._files) {
            try {
                JarFile jar = new JarFile(f);
                this._jars.add(jar);
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Unable to create JarFile for file: " + f);
            }
        }
    }

    public synchronized void close() {
        if (!this._open) {
            return;
        }
        this._open = false;
        for (JarCLInputStream st : this._openStreams) {
            try {
                st.close();
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Failed to close stream");
            }
        }
        this._openStreams = null;
        for (JarFile jar : this._jars) {
            try {
                jar.close();
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Failed to close jar: " + jar);
            }
        }
        this._jars = null;
    }

    private InputStream openInputStream(InputStream in) {
        JarCLInputStream result = new JarCLInputStream(in);
        this._openStreams.add(result);
        return in;
    }

    private synchronized void closeInputStream(JarCLInputStream in) {
        if (this._open) {
            this._openStreams.remove(in);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        Package pkg;
        if (!this._open) {
            throw new ClassNotFoundException("Classloader closed: " + name);
        }
        byte[] b = this.loadClassData(name);
        if (b == null) {
            throw new ClassNotFoundException("Could not find class " + name);
        }
        Class<?> clazz = this.defineClass(name, b, 0, b.length);
        String pkgName = this.getPackageName(name);
        if (pkgName != null && (pkg = this.getDefinedPackage(pkgName)) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        return clazz;
    }

    private String getPackageName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index != -1) {
            return fullyQualifiedName.substring(0, index);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private byte[] loadClassData(String name) {
        int len;
        InputStream input = this.getResourceAsStream(String.valueOf(name = name.replace('.', '/')) + ".class");
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        baos.close();
        byte[] byArray = baos.toByteArray();
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    @Override
    public synchronized InputStream getResourceAsStream(String name) {
        InputStream input = this.getParent().getResourceAsStream(name);
        if (input != null) {
            return input;
        }
        if (!this._open) {
            return null;
        }
        for (JarFile j : this._jars) {
            try {
                ZipEntry entry = j.getEntry(name);
                if (entry == null) continue;
                InputStream zipInput = j.getInputStream(entry);
                return this.openInputStream(zipInput);
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Unable to get entry from jar: " + j);
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (JarFile j : this._jars) {
            ZipEntry entry = j.getEntry(name);
            if (entry == null) continue;
            throw new UnsupportedOperationException("getResource() not implemented: " + name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        throw new UnsupportedOperationException("getResources() not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void _recursiveGetManifestJars(File jarFile, Set<File> manifestJars) {
        String classpath;
        JarFile jar;
        block20: {
            Manifest mf;
            block19: {
                if (!jarFile.exists()) {
                    return;
                }
                jar = null;
                jar = new JarFile(jarFile);
                mf = jar.getManifest();
                if (mf != null) break block19;
                if (jar == null) return;
                try {
                    jar.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            classpath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (classpath != null) break block20;
            if (jar == null) return;
            try {
                jar.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                String[] rgPaths;
                File parent = jarFile.getParentFile();
                String[] stringArray = rgPaths = classpath.split(" ");
                int n = rgPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    File file;
                    String path = stringArray[n2];
                    if (path.length() != 0 && !manifestJars.contains(file = new File(parent, path)) && file.exists()) {
                        manifestJars.add(file);
                        JarClassLoader._recursiveGetManifestJars(file, manifestJars);
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                if (jar == null) return;
                try {
                    jar.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (jar == null) throw throwable;
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (jar == null) return;
        try {
            jar.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private class JarCLInputStream
    extends InputStream {
        private boolean _closed = false;
        private final InputStream _input;

        public JarCLInputStream(InputStream origInput) {
            this._input = origInput;
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            try {
                super.close();
                this._input.close();
                this._closed = true;
            }
            finally {
                JarClassLoader.this.closeInputStream(this);
            }
        }

        @Override
        public int read() throws IOException {
            return this._input.read();
        }

        @Override
        public int available() throws IOException {
            return this._input.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this._input.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this._input.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._input.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._input.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this._input.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._input.skip(n);
        }
    }
}

