/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfHeader;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordIterator;
import org.apache.poi.hemf.record.emf.HemfWindowing;
import org.apache.poi.util.Dimension2DDouble;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;

@Internal
public class HemfPicture
implements Iterable<HemfRecord> {
    private final LittleEndianInputStream stream;
    private final List<HemfRecord> records = new ArrayList<HemfRecord>();
    private boolean isParsed = false;

    public HemfPicture(InputStream is) throws IOException {
        this(new LittleEndianInputStream(is));
    }

    public HemfPicture(LittleEndianInputStream is) throws IOException {
        this.stream = is;
    }

    public HemfHeader getHeader() {
        return (HemfHeader)this.getRecords().get(0);
    }

    public List<HemfRecord> getRecords() {
        if (!this.isParsed) {
            this.isParsed = true;
            HemfHeader[] header = new HemfHeader[1];
            new HemfRecordIterator(this.stream).forEachRemaining(r -> {
                if (r instanceof HemfHeader) {
                    header[0] = (HemfHeader)r;
                }
                r.setHeader(header[0]);
                this.records.add((HemfRecord)r);
            });
        }
        return this.records;
    }

    @Override
    public Iterator<HemfRecord> iterator() {
        return this.getRecords().iterator();
    }

    @Override
    public Spliterator<HemfRecord> spliterator() {
        return this.getRecords().spliterator();
    }

    @Override
    public void forEach(Consumer<? super HemfRecord> action) {
        this.getRecords().forEach(action);
    }

    public Dimension2D getSize() {
        HemfHeader header = (HemfHeader)this.getRecords().get(0);
        double coeff = 2.8346456692913384;
        Rectangle2D dim = header.getFrameRectangle();
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (dim.isEmpty() || Math.rint(width * 2.8346456692913384) == 0.0 || Math.rint(height * 2.8346456692913384) == 0.0) {
            for (HemfRecord r : this.getRecords()) {
                if (!(r instanceof HemfWindowing.EmfSetWindowExtEx)) continue;
                Dimension2D d = ((HemfWindowing.EmfSetWindowExtEx)r).getSize();
                width = d.getWidth();
                height = d.getHeight();
            }
        }
        if (Math.rint(width * 2.8346456692913384) == 0.0 || Math.rint(height * 2.8346456692913384) == 0.0) {
            width = 100.0;
            height = 100.0;
        }
        return new Dimension2DDouble(Math.abs(width * 2.8346456692913384), Math.abs(height * 2.8346456692913384));
    }

    private static double minX(Rectangle2D bounds) {
        return Math.min(bounds.getMinX(), bounds.getMaxX());
    }

    private static double minY(Rectangle2D bounds) {
        return Math.min(bounds.getMinY(), bounds.getMaxY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
        HemfHeader header = (HemfHeader)this.getRecords().get(0);
        AffineTransform at = ctx.getTransform();
        try {
            Rectangle2D emfBounds = header.getBoundsRectangle();
            ctx.translate(HemfPicture.minX(graphicsBounds), HemfPicture.minY(graphicsBounds));
            ctx.scale(graphicsBounds.getWidth() / emfBounds.getWidth(), graphicsBounds.getHeight() / emfBounds.getHeight());
            ctx.translate(-HemfPicture.minX(emfBounds), -HemfPicture.minY(emfBounds));
            int idx = 0;
            HemfGraphics g = new HemfGraphics(ctx, emfBounds);
            for (HemfRecord r : this.getRecords()) {
                try {
                    g.draw(r);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                ++idx;
            }
        }
        finally {
            ctx.setTransform(at);
        }
    }
}

