/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.layouts;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.conn.gmf.GmfLayoutConfigurationStore;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.ILayoutSetup;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.BlockDefinitionDiagramForMultiEditor;
import org.eclipse.ui.IEditorPart;
import org.polarsys.chess.diagramsCreator.connectors.BDDDiagramLayoutConnector;

public class BDDLayoutSetup
implements ILayoutSetup {
    public boolean supports(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object o : collection) {
                if (!this.isEditPart(o)) continue;
                return true;
            }
            return false;
        }
        return this.getBDDDiagramEditor(object) != null || this.isEditPart(object);
    }

    protected boolean isEditPart(Object o) {
        if (o instanceof IGraphicalEditPart) {
            try {
                return ServiceUtilsForEditPart.getInstance().getServiceRegistry((EditPart)((IGraphicalEditPart)o)) != null;
            }
            catch (ServiceException serviceException) {
                return false;
            }
        }
        return false;
    }

    protected DiagramEditor getBDDDiagramEditor(Object object) {
        if (object == null) {
            return null;
        }
        IEditorPart activeEditor = (IEditorPart)Platform.getAdapterManager().getAdapter(object, IEditorPart.class);
        if (activeEditor instanceof IMultiDiagramEditor) {
            activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor();
        }
        if (activeEditor instanceof DiagramEditor && activeEditor instanceof BlockDefinitionDiagramForMultiEditor) {
            return (DiagramEditor)activeEditor;
        }
        return null;
    }

    public Injector createInjector(Module defaultModule) {
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{defaultModule}).with(new Module[]{new BDDLayoutModule()})});
    }

    public static class BDDLayoutModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(IDiagramLayoutConnector.class).to(BDDDiagramLayoutConnector.class);
            binder.bind(ILayoutConfigurationStore.Provider.class).to(GmfLayoutConfigurationStore.Provider.class);
        }
    }
}

