<#macro recurse_macro node>
	<ul>
		<#list node.children as descriptor>
	    <li>
	    	<a href="#${descriptor.name}">${descriptor.name}</a>
	    	<#if descriptor.children?size != 0 >
		 		<@recurse_macro node=descriptor/>
		 	</#if>
	    </li>
	    </#list>
	</ul>
</#macro>

<html>
<head>
    <meta charset="utf-8"/>
    <title>Project: ${title}</title>
    <style>
    body {
      background:white;
      font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
    }

	.tree,
	.tree ul {
	  margin:0;
	  padding:0;
	  list-style:none;
	}

	.tree ul {
	  margin-left:1em; /* indentation */
	  position:relative;
	}

	.tree ul ul {margin-left:.5em} /* (indentation/2) */

	.tree ul:before {
	  content:"";
	  display:block;
	  width:0;
	  position:absolute;
	  top:0;
	  bottom:0;
	  left:0;
	  border-left:1px solid;
	}

	.tree li {
	  margin:0;
	  padding:0 1.5em; /* indentation + .5em */
	  line-height:2em; /* default list item's `line-height` */
	  color:#369;
	  font-weight:bold;
	  position:relative;
	}

	.tree ul li:before {
	  content:"";
	  display:block;
	  width:10px; /* same with indentation */
	  height:0;
	  border-top:1px solid;
	  margin-top:-1px; /* border top width */
	  position:absolute;
	  top:1em; /* (line-height/2) */
	  left:0;
	}

	.tree ul li:last-child:before {
	  background:#eeeeee; /* same with body background */
	  height:auto;
	  top:1em; /* (line-height/2) */
	  bottom:0;
	}

	.page-break {
    	page-break-after: always;
    }

	#header {
      background-color:gray;
      color:white;
      text-align:center;
      position:fixed;
      top: 0px;
      width: 100%;
      height: 60px;
  	}

  	#nav {
      background-color:#eeeeee;
      float:left;
      top:60px;
      width: 20%;
      height: 90%;
      position:fixed;
      overflow:auto;
  	}

	#section {
      float:left;
      top: 60px;
      width:79%;
      height: 90%;
/*      left: 400px;*/
      left: 21%;
      position: fixed;
      overflow:auto;
	}

    /* Adapt image size to the width of the browser */
    img {max-width: 100%;}

    /* Header cell settings */
	th {
        font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
        font-weight: bold;
		text-align: left;
		background-color: lightgray;
	}

    /* Standard cell settings */
	td {
        font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
		text-align: left;
    	width: 300px;
    	max-width:300px;
        min-width:300px;
        overflow:hidden;
	}

    /* Wide cell settings */
	#tdw {
        font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
		text-align: left;
    	width: 500px;
    	max-width:500px;
        min-width:500px;
        overflow:hidden;
	}

    /* Narrow cell settings */
	#tdn {
        font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
		text-align: left;
    	width: 100px;
    	max-width:100px;
        min-width:100px;
        overflow:hidden;
	}

	</style>

    <script type="text/javascript">
    // Original JavaScript code by Chirp Internet: www.chirp.com.au
    // Please acknowledge use of this code by including this header.

    function Hilitor(id, tag, textColor) {

      var targetNode = document.getElementById(id) || document.body;
      var hiliteTag = tag || "EM";
      var skipTags = new RegExp("^(?:" + hiliteTag + "|SCRIPT|FORM|SPAN)$");
      var matchRegex = "";

      // characters to strip from start and end of the input string
      var endCharRegex = new RegExp("^[^\\\w]+|[^\\\w]+$", "g");

      // characters used to break up the input string into words
      var breakCharRegex = new RegExp("[^\\\w'-]+", "g");

      this.setRegex = function(input) {
        input = input.replace(endCharRegex, "");
        input = input.replace(breakCharRegex, "|");
        input = input.replace(/^\||\|$/g, "");
        if(input) {
          var re = "(" + input + ")";
          re = "\\b" + re + "\\b";
//          matchRegex = new RegExp(re, "i"); // Case insensitive
          matchRegex = new RegExp(re);
          return true;
        }
        return false;
      };

      this.getRegex = function() {
        var retval = matchRegex.toString();
        retval = retval.replace(/(^\/(\\b)?|\(|\)|(\\b)?\/i$)/g, "");
        retval = retval.replace(/\|/g, " ");
        return retval;
      };

      // recursively apply word highlighting
      this.hiliteWords = function(node) {
        if(node === undefined || !node) return;
        if(!matchRegex) return;
        if(skipTags.test(node.nodeName)) return;

        if(node.hasChildNodes()) {
          for(var i=0; i < node.childNodes.length; i++)
            this.hiliteWords(node.childNodes[i]);
        }
        if(node.nodeType == 3) { // NODE_TEXT
          if((nv = node.nodeValue) && (regs = matchRegex.exec(nv))) {

            var match = document.createElement(hiliteTag);
            match.appendChild(document.createTextNode(regs[0]));
            match.style.fontStyle = "inherit";
            match.style.fontWeight = 'bold'
//            match.style.color = "#df0000";
            match.style.color = textColor;

            var after = node.splitText(regs.index);
            after.nodeValue = after.nodeValue.substring(regs[0].length);
            node.parentNode.insertBefore(match, after);
          }
        };
      };

      // start highlighting at target node
      this.apply = function(input) {
        if(input === undefined || !input) return;
        if(this.setRegex(input)) {
          this.hiliteWords(targetNode);
        }
      };
    }

    window.onload = function() {
        var myHilitor = new Hilitor("model", "", "#df0000");
        myHilitor.apply("count der min max abs next fall rise change time_since time_until always G never in the future past F then X O historically H previously Y until U releases V since S triggered T at next last iff implies and or xor xnor true TRUE false FALSE not mod CONTRACT DEFINE assume guarantee ASSERTION NAME PARAMETER ASSUMPTIONS big_or big_and refined by");

        myHilitor = new Hilitor("results", "", "#00f000");
        myHilitor.apply("Success");

        myHilitor = new Hilitor("results", "", "#df0000");
        myHilitor.apply("NOT OK");

        myHilitor = new Hilitor("results", "", "#f1af00");
        myHilitor.apply("Unknown");
    }
    </script>

</head>
<body>
 	<div id="header">
        <h1>Project: ${title}</h1>
	</div>

	<div id="nav">
        <h3>Components</h3>
		<ul class="tree">
		  <#list descriptors as descriptor>
		    <li>	    	
		      <a href="#${descriptor.name}">${descriptor.name}</a>
		      <@recurse_macro node=descriptor/>
		    </li>
		  </#list>
		</ul>
        <h3>V&V Results</h3>
       	<ul>
	      <li>
            <a href="#PV">Property Validation Results</a>
          </li>
	      <li>
            <a href="#AGPV">Assume/Guarantee Properties Validation Results</a>
          </li>
	      <li>
            <a href="#CCR">Check Contract Refinement Results</a>
          </li>
	      <li>
            <a href="#CCCI">Check Contract Composite Implementation Results</a>
          </li>
	      <li>
            <a href="#CFTA">Contract-based Fault Tree Analysis Results</a>
          </li>
	      <li>
            <a href="#MCA">Model Checking Results</a>
          </li>
	      <li>
            <a href="#FTA">Fault tree Analysis Results</a>
          </li>
          <li>
            <a href="#FMEA">Failure Modes and Effects Analysis Results</a>
          </li>
        </ul>
	</div>

	<div id="section">

        <!-- model section -->
    	<div id="model">
    	<#list containers as container>
    	<a id="${container.name}"/>
	    <h1>${container.name}</h1>	    
	    <#list container.diagrams as diagram>
        <p>
	      <a href="${diagram.url}" type="image/svg+xml">
            <img src="${diagram.url}" alt="${diagram.url}"> 
          </a>
        </p>
		</#list>

        <#if container.component??>
	    <h2>Component description:</h2>
	    <table border="0" style="width:500px">
	       <thead>
			<tr>			  
			  <th>Type</th>
			  <th>Notes</th>
			</tr>
		  </thead>
		    <tbody>
	  		  <tr>				
				 <#if container.component.type?length != 0>
				   <td>${container.component.type}</td>
				 <#else>
				   <td></td>
		         </#if>
		         <#if container.component.refinementType?length != 0>
				   <td>${container.component.refinementType} refinement</td>
				 <#else>
				   <td></td>
		         </#if>
			  </tr>
			</tbody>
	    </table>
	    <br>

	    <#if (container.component.parameters?size != 0)>
 		<h3>Parameters:</h3>
	    <table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
		    <#list container.component.parameters as parameter>
			  <tr>
				<td>${parameter.name}</td>
				<td><i>${parameter.type}</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
	    </#if>

 		<#if (container.component.localAttributes?size !=0 )>
 		<h3>Local Attributes:</h3>
	    <table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
		    <#list container.component.localAttributes as localAttribute>
			  <tr>
				<td>${localAttribute.name}</td>
                <#if localAttribute.type??>
                  <td><i>${localAttribute.type}</i></td>
                <#else>
                  <td><i>null</i></td>
                </#if>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
	    </#if>

		<#if (container.component.uninterpretedFunctions?size != 0)>
		<h3>Uninterpreted Functions:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Output Type</th>
			  <th>Input Types</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.uninterpretedFunctions as uninterpretedFunction>
			  <tr>
				<td>${uninterpretedFunction.name}</td>
				<td><i>${uninterpretedFunction.type}</i></td>
				<#if uninterpretedFunction.input?length != 0 >
				  <td id="tdw"><i> ${uninterpretedFunction.input}</i></td>
				<#else>
				  <td></td>
				</#if>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
		</#if>

 		<#if (container.component.inputPorts?size !=0 )>
 		<h3>Input ports:</h3>
	    <table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
		    <#list container.component.inputPorts as inputPort>
			  <tr>
				<td>${inputPort.name}</td>
				<td><i>${inputPort.type}</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
	    </#if>

		<#if (container.component.outputPorts?size != 0)>
		<h3>Output ports:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.outputPorts as outputPort>
			  <tr>
				<td>${outputPort.name}</td>
				<td><i>${outputPort.type}</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
		</#if>

        <#if (container.component.subComponents?size != 0)>
		<h3>Subcomponents:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.subComponents as subComponent>
			  <tr>
				<td>${subComponent.name}</td>
				<td><i><a href="#${subComponent.type}">${subComponent.type}</a>
				<#if (subComponent.multiplicity?has_content)>
				  ${subComponent.multiplicity}
				</#if>
				</i></td>				
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
		</#if>

        <#if (container.component.connections?size != 0)>
		<h3>Connections:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Connected Port</th>
			  <th>Connecting Port</th>
			  <th>Iterative Condition</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.connections as connection>
			  <tr>
				<td>${connection.port1}</td>
				<td><i>${connection.port2}</i></td>
				<td id="tdw"><i>
				<#if (connection.iterativeCondition?has_content)>
				  ${connection.iterativeCondition}
				</#if>
				</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
 		<br>
		</#if>
		
        <#if (container.component.defines?size != 0)>
		<h3>Defines:</h3>
        <#list container.component.defines as define>
        <b>DEFINE</b> ${define.name} <b>:= </b> ${define.text}<br>
        <br>
        </#list>
        </#if>

		<#if (container.component.parameterAssumptions?size != 0)>
		<h3>Parameter Assumptions:</h3>
        <#list container.component.parameterAssumptions as parameterAssumptions>
        <b>PARAMETER ASSUMPTIONS</b> ${parameterAssumptions.text} ;<br>
        <br>
        </#list>
        </#if>

<!--        <#if (container.component.interfaceAssertions?size != 0)>
		<h3>Interface Assertions:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Expression</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.interfaceAssertions as assertion>
			  <tr>
				<td>${assertion.name}</td>
				<td id="tdw"><i>${assertion.text}</i></td>				
			  </tr>
			</#list>
		  </tbody>
		</table>
		</#if>

        <#if (container.component.refinementAssertions?size != 0)>
		<h3>Refinement Assertions:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Expression</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.refinementAssertions as assertion>
			  <tr>
				<td>${assertion.name}</td>
				<td><i>${assertion.text}</i></td>				
			  </tr>
			</#list>
		  </tbody>
		</table>
		</#if>
-->
        <#if (container.component.interfaceAssertions?size != 0)>
		<h3>Interface Assertions:</h3>
        <#list container.component.interfaceAssertions as assertion>
    	<a id="${container.name}.${assertion.name}"/>
        <b>ASSERTION NAME</b> ${assertion.name} <b>:= </b> ${assertion.text}<br>
        <br>
        </#list>
        </#if>

        <#if (container.component.refinementAssertions?size != 0)>
		<h3>Refinement Assertions:</h3>
        <#list container.component.refinementAssertions as assertion>
        ASSERTION NAME ${assertion.name} := ${assertion.text}<br>
        <br>
        </#list>
        </#if>

<!--        <#if (container.component.contracts?size != 0)>
		<h3>Contracts:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Assumption</th>
			  <th>Guarantee</th>
			</tr>
		  </thead>
		  <tbody>
			<#list container.component.contracts as contract>
			  <tr>
				<td>${contract.name}</td>
				<td><i>${contract.assumption}</i></td>
				<td><i>${contract.guarantee}</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
		</#if>
-->

        <#if (container.component.contracts?size != 0)>
		<h3>Contracts:</h3>
        <#list container.component.contracts as contract>
        CONTRACT ${contract.name}<br>
        assume: 
		<#if (contract.assumptionLink?has_content)>
        <a href="#${contract.assumptionLink}">${contract.assumption}</a>
        <#else>
        ${contract.assumption}
        </#if><br>
        guarantee:
		<#if (contract.guaranteeLink?has_content)>
        <a href="#${contract.guaranteeLink}">${contract.guarantee}</a>
        <#else>
        ${contract.guarantee}
        </#if><br>
        <br>
        </#list>
 		<br>
        </#if>

        <#if (container.component.contractRefinements?size != 0)>
		<h3>Contract Refinements:</h3>
        <#list container.component.contractRefinements as contractRefinement>
        CONTRACT ${contractRefinement.refinedContractName}<br>
        refined by: 		
        ${contractRefinement.refiningContractsNames}
        <br>
        <br>
        </#list>
 		<br>
        </#if>
	    </#if>  
        <hr> 
	    <p class="page-break"/>
		</#list>
	    </div>


        <!-- results section -->
    	<div id="results">
    	<a id="Results"/>
		<#list descriptors as descriptor>
          <#if descriptor.showAnalysisResults??>
   	      <h1>Validation and Verification Results</h1>            
          <a id="PV"/>
		  <h2>Properties Validation Results:</h2>
          <#if (descriptor.propertyValidationResults?size != 0)>
            <#list descriptor.propertyValidationResults as propertyValidationResult>
              <b>Main class:</b><a href="#${propertyValidationResult.rootClass}"> ${propertyValidationResult.rootClass}</a><br>
              <b>Type of validation:</b> ${propertyValidationResult.validationType}<br>
              <#if (propertyValidationResult.selectedComponent??)>
                <b>Selected component:</b> ${propertyValidationResult.selectedComponent}<br>
              </#if>
              <#if (propertyValidationResult.selectedProperties??)>
                <b>Selected properties:</b> ${propertyValidationResult.selectedProperties}<br>
              </#if>
              <#if (propertyValidationResult.conditions??)>
                <b>Conditions:</b> ${propertyValidationResult.conditions}<br>
              </#if>
    	      <table border="0" style="width:500px">
    	        <thead>
        	  	  <tr>
    		        <th>Property</th>
    		        <th>Status</th>
			      </tr>
		        </thead>
		        <tbody>
                  <#list propertyValidationResult.validationLines as line>
	                <tr>
		              <td>${line.property}</td>
                      <td id="tdn">${line.status}</td>
                    </tr>
                  </#list>
	            </tbody>
              </table> 
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="AGPV"/>
		  <h2>Assume/Guarantee Properties Validation Results:</h2>
          <#if (descriptor.contractPropertyValidationResults?size != 0)>
            <#list descriptor.contractPropertyValidationResults as contractPropertyValidationResult>
              <b>Main class:</b><a href="#${contractPropertyValidationResult.rootClass}"> ${contractPropertyValidationResult.rootClass}</a><br>
              <b>Type of validation:</b> ${contractPropertyValidationResult.validationType}<br>
              <#if (contractPropertyValidationResult.selectedComponent??)>
                <b>Selected component:</b> ${contractPropertyValidationResult.selectedComponent}<br>
              </#if>
              <#if (contractPropertyValidationResult.selectedProperties??)>
                <b>Selected properties:</b> ${contractPropertyValidationResult.selectedProperties}<br>
              </#if>
              <#if (contractPropertyValidationResult.conditions??)>
                <b>Conditions:</b> ${contractPropertyValidationResult.conditions}<br>
              </#if>
    	      <table border="0" style="width:500px">
    	        <thead>
        	  	  <tr>
    		        <th>Property</th>
    		        <th>Status</th>
			      </tr>
		        </thead>
		        <tbody>
                  <#list contractPropertyValidationResult.validationLines as line>
	                <tr>
		              <td>${line.property}</td>
                      <td id="tdn">${line.status}</td>
                    </tr>
                  </#list>
	            </tbody>
              </table> 
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="CCR"/>
		  <h2>Check Contract Refinement Results:</h2>
          <#if (descriptor.contractRefinementResults?size != 0)>
            <#list descriptor.contractRefinementResults as contractRefinementResult>
              <b>Main class:</b><a href="#${contractRefinementResult.rootClass}"> ${contractRefinementResult.rootClass}</a><br>
    	      <table border="0" style="width:500px">
    	        <thead>
        	  	  <tr>
    		        <th>Contract</th>
    		        <th>Status</th>
			      </tr>
		        </thead>
		        <tbody>
                  <#list contractRefinementResult.refinementLines as line>
	                <tr>
		              <td>${line.contract}</td>
                      <td id="tdn">${line.status}</td>
                    </tr>
                  </#list>
	            </tbody>
              </table> 
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="CCCI"/>
		  <h2>Check Contract Composite Implementation Results:</h2>
          <#if (descriptor.contractImplementationResults?size != 0)>
            <#list descriptor.contractImplementationResults as contractImplementationResult>
              <b>Main class:</b><a href="#${contractImplementationResult.rootClass}"> ${contractImplementationResult.rootClass}</a><br>
    	      <table border="0" style="width:500px">
    	        <thead>
        	  	  <tr>
    		        <th>Contract</th>
    		        <th>Status</th>
			      </tr>
		        </thead>
		        <tbody>
                  <#list contractImplementationResult.implementationLines as line>
	                <tr>
		              <td>${line.contract}</td>
                      <td id="tdn">${line.status}</td>
                    </tr>
                  </#list>
	            </tbody>
              </table> 
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="CFTA"/>
          <h2>Contract-based Fault Tree Analysis Results:</h2>
          <#if (descriptor.contractFtaResults?size != 0)>
            <#list descriptor.contractFtaResults as contractFtaResult>
              <b>Main class:</b><a href="#${contractFtaResult.rootClass}"> ${contractFtaResult.rootClass}</a><br>
              <p>
	            <a href="${contractFtaResult.url}" type="image/svg+xml">
                  <img src="${contractFtaResult.url}" alt="${contractFtaResult.url}"> 
                </a>
              </p>
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="MCA"/>
          <h2>Model Checking Results:</h2>
          <#if (descriptor.modelCheckingResults?size != 0)>
            <#list descriptor.modelCheckingResults as modelCheckingResult>
              <b>Main class:</b><a href="#${modelCheckingResult.rootClass}"> ${modelCheckingResult.rootClass}</a><br>
              <b>Type of check:</b> ${modelCheckingResult.checkType}<br>
              <b>Conditions:</b> ${modelCheckingResult.conditions}<br>
              <b>Model status:</b> ${modelCheckingResult.result}<br>
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="FTA"/>
		  <h2>Fault Tree Analysis Results:</h2>
          <#if (descriptor.ftaResults?size != 0)>
            <#list descriptor.ftaResults as ftaResult>
              <b>Main class:</b><a href="#${ftaResult.rootClass}"> ${ftaResult.rootClass}</a><br>
              <b>Conditions:</b> ${ftaResult.conditions}<br>
              <p>
	            <a href="${ftaResult.url}" type="image/svg+xml">
                  <img src="${ftaResult.url}" alt="${ftaResult.url}"> 
                </a>
              </p>
              <br>
              <br>
            </#list>
          <#else>
            <i>Results not available.</i>
          </#if>
          <br>
          <br>
          <hr>
          <a id="FMEA"/>
		  <h2>Failure Modes and Effects Analysis Results:</h2>
          <#if (descriptor.fmeaResults?size != 0)>
            <#list descriptor.fmeaResults as fmeaResult>
              <b>Main class:</b><a href="#${fmeaResult.rootClass}"> ${fmeaResult.rootClass}</a><br>
              <b>Conditions:</b> ${fmeaResult.conditions}<br>
    	      <table border="0" style="width:500px">
    	        <thead>
        	  	  <tr>
    		        <th>Entry ID</th>
    		        <th>Failure Mode</th>
    		        <th>Failure Effects</th>
			      </tr>
		        </thead>
		        <tbody>
                  <#list fmeaResult.fmeaLines as line>
	                <tr>
		              <td id="tdn">${line.entry}</td>
                      <td id="tdw">${line.failureMode}</td>
                      <td>${line.failureEffects}</td>
                    </tr>
                  </#list>
	            </tbody>
              </table> 
              <br>
              <br>  
            </#list>
            <br>
            <br>
          <#else>
            <i>Results not available.</i>
          </#if>
        </#if>
        </#list>
    	</div>
	</div>
</body>
</html>
