/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results.impl;

import eu.fbk.tools.adapter.results.BehaviourCheckResult;
import eu.fbk.tools.adapter.results.ContractCheckResult;
import eu.fbk.tools.adapter.results.ContractPropertyValidationResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.results.ResultsPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model Check Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl#getContractCheckResults <em>Contract Check Results</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl#getBehaviourCheckResults <em>Behaviour Check Results</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl#getPropertyValidationResults <em>Property Validation Results</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModelCheckResultImpl extends MinimalEObjectImpl.Container implements ModelCheckResult {
	/**
	 * The cached value of the '{@link #getContractCheckResults() <em>Contract Check Results</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContractCheckResults()
	 * @generated
	 * @ordered
	 */
	protected EList<ContractCheckResult> contractCheckResults;

	/**
	 * The cached value of the '{@link #getBehaviourCheckResults() <em>Behaviour Check Results</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehaviourCheckResults()
	 * @generated
	 * @ordered
	 */
	protected EList<BehaviourCheckResult> behaviourCheckResults;

	/**
	 * The cached value of the '{@link #getPropertyValidationResults() <em>Property Validation Results</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyValidationResults()
	 * @generated
	 * @ordered
	 */
	protected EList<ContractPropertyValidationResult> propertyValidationResults;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelCheckResultImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResultsPackage.Literals.MODEL_CHECK_RESULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ContractCheckResult> getContractCheckResults() {
		if (contractCheckResults == null) {
			contractCheckResults = new EObjectContainmentEList<ContractCheckResult>(ContractCheckResult.class, this, ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS);
		}
		return contractCheckResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BehaviourCheckResult> getBehaviourCheckResults() {
		if (behaviourCheckResults == null) {
			behaviourCheckResults = new EObjectContainmentEList<BehaviourCheckResult>(BehaviourCheckResult.class, this, ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS);
		}
		return behaviourCheckResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ContractPropertyValidationResult> getPropertyValidationResults() {
		if (propertyValidationResults == null) {
			propertyValidationResults = new EObjectContainmentEList<ContractPropertyValidationResult>(ContractPropertyValidationResult.class, this, ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS);
		}
		return propertyValidationResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS:
				return ((InternalEList<?>)getContractCheckResults()).basicRemove(otherEnd, msgs);
			case ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS:
				return ((InternalEList<?>)getBehaviourCheckResults()).basicRemove(otherEnd, msgs);
			case ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS:
				return ((InternalEList<?>)getPropertyValidationResults()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS:
				return getContractCheckResults();
			case ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS:
				return getBehaviourCheckResults();
			case ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS:
				return getPropertyValidationResults();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS:
				getContractCheckResults().clear();
				getContractCheckResults().addAll((Collection<? extends ContractCheckResult>)newValue);
				return;
			case ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS:
				getBehaviourCheckResults().clear();
				getBehaviourCheckResults().addAll((Collection<? extends BehaviourCheckResult>)newValue);
				return;
			case ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS:
				getPropertyValidationResults().clear();
				getPropertyValidationResults().addAll((Collection<? extends ContractPropertyValidationResult>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS:
				getContractCheckResults().clear();
				return;
			case ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS:
				getBehaviourCheckResults().clear();
				return;
			case ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS:
				getPropertyValidationResults().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResultsPackage.MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS:
				return contractCheckResults != null && !contractCheckResults.isEmpty();
			case ResultsPackage.MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS:
				return behaviourCheckResults != null && !behaviourCheckResults.isEmpty();
			case ResultsPackage.MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS:
				return propertyValidationResults != null && !propertyValidationResults.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ModelCheckResultImpl
