/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results.impl;

import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ResultsPackage;
import eu.fbk.tools.adapter.results.Trace;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Check Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl#getProofType <em>Proof Type</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl#getValue <em>Value</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl#getContractName <em>Contract Name</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl#getTraces <em>Traces</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CheckResultImpl extends MinimalEObjectImpl.Container implements CheckResult {
	/**
	 * The default value of the '{@link #getProofType() <em>Proof Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProofType()
	 * @generated
	 * @ordered
	 */
	protected static final String PROOF_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProofType() <em>Proof Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProofType()
	 * @generated
	 * @ordered
	 */
	protected String proofType = PROOF_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final String VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected String value = VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getContractName() <em>Contract Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContractName()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTRACT_NAME_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getContractName() <em>Contract Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContractName()
	 * @generated
	 * @ordered
	 */
	protected String contractName = CONTRACT_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTraces() <em>Traces</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTraces()
	 * @generated
	 * @ordered
	 */
	protected EList<Trace> traces;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CheckResultImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResultsPackage.Literals.CHECK_RESULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProofType() {
		return proofType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProofType(String newProofType) {
		String oldProofType = proofType;
		proofType = newProofType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.CHECK_RESULT__PROOF_TYPE, oldProofType, proofType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(String newValue) {
		String oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.CHECK_RESULT__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContractName() {
		return contractName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContractName(String newContractName) {
		String oldContractName = contractName;
		contractName = newContractName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.CHECK_RESULT__CONTRACT_NAME, oldContractName, contractName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Trace> getTraces() {
		if (traces == null) {
			traces = new EObjectContainmentEList<Trace>(Trace.class, this, ResultsPackage.CHECK_RESULT__TRACES);
		}
		return traces;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResultsPackage.CHECK_RESULT__TRACES:
				return ((InternalEList<?>)getTraces()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResultsPackage.CHECK_RESULT__PROOF_TYPE:
				return getProofType();
			case ResultsPackage.CHECK_RESULT__VALUE:
				return getValue();
			case ResultsPackage.CHECK_RESULT__CONTRACT_NAME:
				return getContractName();
			case ResultsPackage.CHECK_RESULT__TRACES:
				return getTraces();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResultsPackage.CHECK_RESULT__PROOF_TYPE:
				setProofType((String)newValue);
				return;
			case ResultsPackage.CHECK_RESULT__VALUE:
				setValue((String)newValue);
				return;
			case ResultsPackage.CHECK_RESULT__CONTRACT_NAME:
				setContractName((String)newValue);
				return;
			case ResultsPackage.CHECK_RESULT__TRACES:
				getTraces().clear();
				getTraces().addAll((Collection<? extends Trace>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResultsPackage.CHECK_RESULT__PROOF_TYPE:
				setProofType(PROOF_TYPE_EDEFAULT);
				return;
			case ResultsPackage.CHECK_RESULT__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case ResultsPackage.CHECK_RESULT__CONTRACT_NAME:
				setContractName(CONTRACT_NAME_EDEFAULT);
				return;
			case ResultsPackage.CHECK_RESULT__TRACES:
				getTraces().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResultsPackage.CHECK_RESULT__PROOF_TYPE:
				return PROOF_TYPE_EDEFAULT == null ? proofType != null : !PROOF_TYPE_EDEFAULT.equals(proofType);
			case ResultsPackage.CHECK_RESULT__VALUE:
				return VALUE_EDEFAULT == null ? value != null : !VALUE_EDEFAULT.equals(value);
			case ResultsPackage.CHECK_RESULT__CONTRACT_NAME:
				return CONTRACT_NAME_EDEFAULT == null ? contractName != null : !CONTRACT_NAME_EDEFAULT.equals(contractName);
			case ResultsPackage.CHECK_RESULT__TRACES:
				return traces != null && !traces.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (proofType: ");
		result.append(proofType);
		result.append(", value: ");
		result.append(value);
		result.append(", contractName: ");
		result.append(contractName);
		result.append(')');
		return result.toString();
	}

} //CheckResultImpl
