/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results.impl;

import eu.fbk.tools.adapter.results.AbstractCheckResult;
import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ResultsPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Check Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl#getModelName <em>Model Name</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl#getCheckType <em>Check Type</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl#getFailed <em>Failed</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl#getTimeStamp <em>Time Stamp</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl#getCheckResults <em>Check Results</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class AbstractCheckResultImpl extends MinimalEObjectImpl.Container implements AbstractCheckResult {
	/**
	 * The default value of the '{@link #getModelName() <em>Model Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelName()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModelName() <em>Model Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelName()
	 * @generated
	 * @ordered
	 */
	protected String modelName = MODEL_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCheckType() <em>Check Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckType()
	 * @generated
	 * @ordered
	 */
	protected static final String CHECK_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCheckType() <em>Check Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckType()
	 * @generated
	 * @ordered
	 */
	protected String checkType = CHECK_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getFailed() <em>Failed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailed()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean FAILED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFailed() <em>Failed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailed()
	 * @generated
	 * @ordered
	 */
	protected Boolean failed = FAILED_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimeStamp() <em>Time Stamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeStamp()
	 * @generated
	 * @ordered
	 */
	protected static final long TIME_STAMP_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimeStamp() <em>Time Stamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeStamp()
	 * @generated
	 * @ordered
	 */
	protected long timeStamp = TIME_STAMP_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCheckResults() <em>Check Results</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckResults()
	 * @generated
	 * @ordered
	 */
	protected EList<CheckResult> checkResults;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractCheckResultImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResultsPackage.Literals.ABSTRACT_CHECK_RESULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getModelName() {
		return modelName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelName(String newModelName) {
		String oldModelName = modelName;
		modelName = newModelName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.ABSTRACT_CHECK_RESULT__MODEL_NAME, oldModelName, modelName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCheckType() {
		return checkType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheckType(String newCheckType) {
		String oldCheckType = checkType;
		checkType = newCheckType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_TYPE, oldCheckType, checkType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Boolean getFailed() {
		return failed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFailed(Boolean newFailed) {
		Boolean oldFailed = failed;
		failed = newFailed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.ABSTRACT_CHECK_RESULT__FAILED, oldFailed, failed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimeStamp() {
		return timeStamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimeStamp(long newTimeStamp) {
		long oldTimeStamp = timeStamp;
		timeStamp = newTimeStamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultsPackage.ABSTRACT_CHECK_RESULT__TIME_STAMP, oldTimeStamp, timeStamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CheckResult> getCheckResults() {
		if (checkResults == null) {
			checkResults = new EObjectContainmentEList<CheckResult>(CheckResult.class, this, ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS);
		}
		return checkResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS:
				return ((InternalEList<?>)getCheckResults()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResultsPackage.ABSTRACT_CHECK_RESULT__MODEL_NAME:
				return getModelName();
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_TYPE:
				return getCheckType();
			case ResultsPackage.ABSTRACT_CHECK_RESULT__FAILED:
				return getFailed();
			case ResultsPackage.ABSTRACT_CHECK_RESULT__TIME_STAMP:
				return getTimeStamp();
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS:
				return getCheckResults();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResultsPackage.ABSTRACT_CHECK_RESULT__MODEL_NAME:
				setModelName((String)newValue);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_TYPE:
				setCheckType((String)newValue);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__FAILED:
				setFailed((Boolean)newValue);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__TIME_STAMP:
				setTimeStamp((Long)newValue);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS:
				getCheckResults().clear();
				getCheckResults().addAll((Collection<? extends CheckResult>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResultsPackage.ABSTRACT_CHECK_RESULT__MODEL_NAME:
				setModelName(MODEL_NAME_EDEFAULT);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_TYPE:
				setCheckType(CHECK_TYPE_EDEFAULT);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__FAILED:
				setFailed(FAILED_EDEFAULT);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__TIME_STAMP:
				setTimeStamp(TIME_STAMP_EDEFAULT);
				return;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS:
				getCheckResults().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResultsPackage.ABSTRACT_CHECK_RESULT__MODEL_NAME:
				return MODEL_NAME_EDEFAULT == null ? modelName != null : !MODEL_NAME_EDEFAULT.equals(modelName);
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_TYPE:
				return CHECK_TYPE_EDEFAULT == null ? checkType != null : !CHECK_TYPE_EDEFAULT.equals(checkType);
			case ResultsPackage.ABSTRACT_CHECK_RESULT__FAILED:
				return FAILED_EDEFAULT == null ? failed != null : !FAILED_EDEFAULT.equals(failed);
			case ResultsPackage.ABSTRACT_CHECK_RESULT__TIME_STAMP:
				return timeStamp != TIME_STAMP_EDEFAULT;
			case ResultsPackage.ABSTRACT_CHECK_RESULT__CHECK_RESULTS:
				return checkResults != null && !checkResults.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (modelName: ");
		result.append(modelName);
		result.append(", checkType: ");
		result.append(checkType);
		result.append(", failed: ");
		result.append(failed);
		result.append(", timeStamp: ");
		result.append(timeStamp);
		result.append(')');
		return result.toString();
	}

} //AbstractCheckResultImpl
