/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Model Check Result</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.ModelCheckResult#getContractCheckResults <em>Contract Check Results</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.ModelCheckResult#getBehaviourCheckResults <em>Behaviour Check Results</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.ModelCheckResult#getPropertyValidationResults <em>Property Validation Results</em>}</li>
 * </ul>
 *
 * @see eu.fbk.tools.adapter.results.ResultsPackage#getModelCheckResult()
 * @model
 * @generated
 */
public interface ModelCheckResult extends EObject {
	/**
	 * Returns the value of the '<em><b>Contract Check Results</b></em>' containment reference list.
	 * The list contents are of type {@link eu.fbk.tools.adapter.results.ContractCheckResult}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Contract Check Results</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contract Check Results</em>' containment reference list.
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getModelCheckResult_ContractCheckResults()
	 * @model containment="true"
	 * @generated
	 */
	EList<ContractCheckResult> getContractCheckResults();

	/**
	 * Returns the value of the '<em><b>Behaviour Check Results</b></em>' containment reference list.
	 * The list contents are of type {@link eu.fbk.tools.adapter.results.BehaviourCheckResult}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Behaviour Check Results</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Behaviour Check Results</em>' containment reference list.
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getModelCheckResult_BehaviourCheckResults()
	 * @model containment="true"
	 * @generated
	 */
	EList<BehaviourCheckResult> getBehaviourCheckResults();

	/**
	 * Returns the value of the '<em><b>Property Validation Results</b></em>' containment reference list.
	 * The list contents are of type {@link eu.fbk.tools.adapter.results.ContractPropertyValidationResult}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Property Validation Results</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Property Validation Results</em>' containment reference list.
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getModelCheckResult_PropertyValidationResults()
	 * @model containment="true"
	 * @generated
	 */
	EList<ContractPropertyValidationResult> getPropertyValidationResults();

} // ModelCheckResult
