/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Check Result</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.CheckResult#getProofType <em>Proof Type</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.CheckResult#getValue <em>Value</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.CheckResult#getContractName <em>Contract Name</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.CheckResult#getTraces <em>Traces</em>}</li>
 * </ul>
 *
 * @see eu.fbk.tools.adapter.results.ResultsPackage#getCheckResult()
 * @model
 * @generated
 */
public interface CheckResult extends EObject {
	/**
	 * Returns the value of the '<em><b>Proof Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Proof Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Proof Type</em>' attribute.
	 * @see #setProofType(String)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getCheckResult_ProofType()
	 * @model required="true"
	 * @generated
	 */
	String getProofType();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.CheckResult#getProofType <em>Proof Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Proof Type</em>' attribute.
	 * @see #getProofType()
	 * @generated
	 */
	void setProofType(String value);

	/**
	 * Returns the value of the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value</em>' attribute.
	 * @see #setValue(String)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getCheckResult_Value()
	 * @model required="true"
	 * @generated
	 */
	String getValue();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.CheckResult#getValue <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value</em>' attribute.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(String value);

	/**
	 * Returns the value of the '<em><b>Contract Name</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Contract Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contract Name</em>' attribute.
	 * @see #setContractName(String)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getCheckResult_ContractName()
	 * @model default=""
	 * @generated
	 */
	String getContractName();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.CheckResult#getContractName <em>Contract Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Contract Name</em>' attribute.
	 * @see #getContractName()
	 * @generated
	 */
	void setContractName(String value);

	/**
	 * Returns the value of the '<em><b>Traces</b></em>' containment reference list.
	 * The list contents are of type {@link eu.fbk.tools.adapter.results.Trace}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Traces</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Traces</em>' containment reference list.
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getCheckResult_Traces()
	 * @model containment="true"
	 * @generated
	 */
	EList<Trace> getTraces();

} // CheckResult
