/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Abstract Check Result</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getModelName <em>Model Name</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckType <em>Check Type</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getFailed <em>Failed</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getTimeStamp <em>Time Stamp</em>}</li>
 *   <li>{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckResults <em>Check Results</em>}</li>
 * </ul>
 *
 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult()
 * @model abstract="true"
 * @generated
 */
public interface AbstractCheckResult extends EObject {
	/**
	 * Returns the value of the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Model Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model Name</em>' attribute.
	 * @see #setModelName(String)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult_ModelName()
	 * @model required="true"
	 * @generated
	 */
	String getModelName();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getModelName <em>Model Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model Name</em>' attribute.
	 * @see #getModelName()
	 * @generated
	 */
	void setModelName(String value);

	/**
	 * Returns the value of the '<em><b>Check Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Check Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Check Type</em>' attribute.
	 * @see #setCheckType(String)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult_CheckType()
	 * @model required="true"
	 * @generated
	 */
	String getCheckType();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckType <em>Check Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Check Type</em>' attribute.
	 * @see #getCheckType()
	 * @generated
	 */
	void setCheckType(String value);

	/**
	 * Returns the value of the '<em><b>Failed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Failed</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Failed</em>' attribute.
	 * @see #setFailed(Boolean)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult_Failed()
	 * @model required="true"
	 * @generated
	 */
	Boolean getFailed();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getFailed <em>Failed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Failed</em>' attribute.
	 * @see #getFailed()
	 * @generated
	 */
	void setFailed(Boolean value);

	/**
	 * Returns the value of the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Time Stamp</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Time Stamp</em>' attribute.
	 * @see #setTimeStamp(long)
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult_TimeStamp()
	 * @model
	 * @generated
	 */
	long getTimeStamp();

	/**
	 * Sets the value of the '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getTimeStamp <em>Time Stamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time Stamp</em>' attribute.
	 * @see #getTimeStamp()
	 * @generated
	 */
	void setTimeStamp(long value);

	/**
	 * Returns the value of the '<em><b>Check Results</b></em>' containment reference list.
	 * The list contents are of type {@link eu.fbk.tools.adapter.results.CheckResult}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Check Results</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Check Results</em>' containment reference list.
	 * @see eu.fbk.tools.adapter.results.ResultsPackage#getAbstractCheckResult_CheckResults()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<CheckResult> getCheckResults();

} // AbstractCheckResult
