/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOFetchFeatureInfo {
    private long timeBeforeUsed;
    private long latencyTime;
    private boolean active;
    private EClass eClass;
    private EStructuralFeature feature;

    public CDOFetchFeatureInfo(EClass eClass, EStructuralFeature feature) {
        this.eClass = eClass;
        this.feature = feature;
        this.active = false;
        this.latencyTime = -1L;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.feature;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getTimeBeforeUsed() {
        return this.timeBeforeUsed;
    }

    public void setTimeBeforeUsed(long timeBeforeUsed) {
        this.timeBeforeUsed = timeBeforeUsed;
    }

    public long getLatencyTime() {
        return this.latencyTime;
    }

    public void setLatencyTime(long latencyTime) {
        this.latencyTime = latencyTime;
    }

    public void updateLatencyTime(long latencyTime) {
        if (this.getLatencyTime() == -1L) {
            this.setLatencyTime(latencyTime);
        } else {
            this.setLatencyTime((latencyTime + this.getLatencyTime()) / 2L);
        }
    }

    public void updateTimeInfo(long elapseTimeBeforeLastRequest) {
        if (this.getTimeBeforeUsed() == 0L) {
            this.setTimeBeforeUsed(elapseTimeBeforeLastRequest);
        } else {
            this.setTimeBeforeUsed((this.getTimeBeforeUsed() + elapseTimeBeforeLastRequest) / 2L);
        }
    }

    public int hashCode() {
        return this.eClass.hashCode() ^ this.feature.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOFetchFeatureInfo) {
            CDOFetchFeatureInfo featureInfo = (CDOFetchFeatureInfo)obj;
            return featureInfo.eClass == this.eClass && featureInfo.feature == this.feature;
        }
        return false;
    }
}

