/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.test;

import com.google.inject.Inject;
import eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.visitors.CleanCTranslatorToPython;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.tests.ExpressionInjectorProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=ExpressionInjectorProvider.class)
public class TestExpression {
    @Inject
    private ParseHelper<Expression> exprParseHelper;
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Before
    public void beforeTest() {
    }

    @Test
    public void testExpression() {
        HashMap<String, String> mapInputExprValue = new HashMap<String, String>();
        mapInputExprValue.put("1", "1");
        mapInputExprValue.put("var", "var");
        mapInputExprValue.put("locVar", "self.locVar");
        mapInputExprValue.put("(v + x) * (t % r) / f", "(v + x) * (t % r) / f");
        mapInputExprValue.put("var - 1", "var - 1");
        mapInputExprValue.put("((((((i == z)< s)<=c )   > f) >= h)!= o)", "((((((i == z) < s) <= c) > f) >= h) != o)");
        mapInputExprValue.put("((j < in) | (j > in)) & ((j <= in) | (j >= in))", "((j < in) | (j > in)) & ((j <= in) | (j >= in))");
        mapInputExprValue.put("l[10] + 1", "l[10] + 1");
        mapInputExprValue.put("l[10][3] + 1", "l[10][3] + 1");
        mapInputExprValue.put("locVar[10][3] + 1", "self.locVar[10][3] + 1");
        mapInputExprValue.put("argc != 2", "argc != 2");
        mapInputExprValue.put("((real)init - 32768.0) / 16384.0", "(init - 32768.0) / 16384.0");
        mapInputExprValue.put("2315*init % 65536", "2315 * init % 65536");
        mapInputExprValue.put("\"Calling\"", "\"Calling\"");
        mapInputExprValue.put("((false &&  true)|| !true)", "((False and True) or not True)");
        mapInputExprValue.put("f(c) + g(a,4,e)", "f(c) + g(a, 4, e)");
        mapInputExprValue.put("(a >> b) | (a << b) % a", "(a >> b) | (a << b) % a");
        mapInputExprValue.put("(+a) + (-a) + (~a)", "(+a) + (-a) + (~a)");
        mapInputExprValue.put("(+locVar) + (-locVar) + (~locVar)", "(+self.locVar) + (-self.locVar) + (~self.locVar)");
        mapInputExprValue.put(".2349", ".2349");
        mapInputExprValue.put("locVar.locVar", "self.locVar.locVar");
        mapInputExprValue.put("locVar.a.b.c.d.e()", "self.locVar.a.b.c.d.e()");
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        List<String> literalsNamesMap = null;
        for (Map.Entry pair : mapInputExprValue.entrySet()) {
            this.checkExpressionPair((String)pair.getKey(), (String)pair.getValue(), typeAssignmentCache, literalsNamesMap);
        }
    }

    @Test
    public void testExpression2() {
        HashMap<String, String> mapInputExprValue = new HashMap<String, String>();
        mapInputExprValue.put("locVar.locVar", "self.locVar.locVar");
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        List<String> literalsNamesMap = null;
        for (Map.Entry pair : mapInputExprValue.entrySet()) {
            this.checkExpressionPair((String)pair.getKey(), (String)pair.getValue(), typeAssignmentCache, literalsNamesMap);
        }
    }

    @Test
    public void testExpression3() {
        HashMap<String, String> mapInputExprValue = new HashMap<String, String>();
        mapInputExprValue.put("locVar.a.b[5].c.d.e()", "self.locVar.a.b[5].c.d.e()");
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        List<String> literalsNamesMap = null;
        for (Map.Entry pair : mapInputExprValue.entrySet()) {
            this.checkExpressionPair((String)pair.getKey(), (String)pair.getValue(), typeAssignmentCache, literalsNamesMap);
        }
    }

    private void checkExpressionPair(String cleanCString, String expectedPythonResult, HashMap<String, Object> typeAssignmentCache, List<String> literalsNamesMap) {
        try {
            Expression expr = (Expression)this.exprParseHelper.parse((CharSequence)cleanCString);
            SysMLElementExtractor elementExtractor = new SysMLElementExtractor(null, null, null);
            CleanCTranslatorToPython cleanCTranslatorToPython = new CleanCTranslatorToPython(elementExtractor, false, literalsNamesMap);
            cleanCTranslatorToPython.addAllVariableInGlobalVariablesCache(typeAssignmentCache);
            String result = cleanCTranslatorToPython.process((EObject)expr);
            Assert.assertTrue((String)("Wrong translation. \n Expected result: '" + expectedPythonResult + "'\n result: '" + result + "'"), (boolean)expectedPythonResult.equals(result));
        }
        catch (Exception e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

