/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.utils.IModuleSourceInfo;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ASTBindingHelper {
    public static int getEndPosition(@NonNull Element element) {
        ModelElementCS csElement = ElementUtil.getCsElement((Element)element);
        if (csElement == null) {
            return 0;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node == null) {
            return 0;
        }
        return ElementUtil.getEndOffset((INode)node);
    }

    public static int getStartPosition(@NonNull Element element) {
        ModelElementCS csElement = ElementUtil.getCsElement((Element)element);
        if (csElement == null) {
            return 0;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node == null) {
            return 0;
        }
        return node.getOffset();
    }

    public static IModuleSourceInfo getModuleSourceBinding(@NonNull Element element) {
        return new UnitLocation2(element);
    }

    private static final class UnitLocation2
    implements IModuleSourceInfo,
    LineNumberProvider {
        private @Nullable ModelElementCS csElement;
        private @Nullable ICompositeNode node;

        private UnitLocation2(@NonNull Element asElement) {
            this.csElement = ElementUtil.getCsElement((Element)asElement);
            if (this.csElement != null) {
                this.node = NodeModelUtils.getNode((EObject)this.csElement);
            }
        }

        @Override
        public int getLineCount() {
            ICompositeNode node2 = this.node;
            return node2 != null ? node2.getStartLine() : 0;
        }

        @Override
        public int getLineEnd(int lineNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLineNumber(int offset) {
            ICompositeNode node2 = this.node;
            if (node2 != null) {
                ILeafNode leafNode;
                int nodeOffset = node2.getOffset();
                if (offset == nodeOffset) {
                    return node2.getStartLine();
                }
                ICompositeNode rootNode = node2.getRootNode();
                if (rootNode != null && (leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)offset)) != null) {
                    return leafNode.getStartLine();
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull LineNumberProvider getLineNumberProvider() {
            return this;
        }

        @Override
        public @Nullable URI getSourceURI() {
            ModelElementCS csElement2 = this.csElement;
            return csElement2 != null ? csElement2.eResource().getURI() : null;
        }
    }
}

