/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.nuXmvService.ui.services;

import eu.fbk.eclipse.standardtools.nuXmvService.ui.dialogs.NuXmvParametersDialog;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.tools.Request;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class NuXmvExecService {
    private static NuXmvExecService nuXmvService;
    private NuXmvParametersDialog dialog;
    private AbstractSystemModel abstractSystemModel;

    public static NuXmvExecService getInstance(AbstractSystemModel abstractSystemModel) {
        if (nuXmvService == null) {
            nuXmvService = new NuXmvExecService(abstractSystemModel);
        }
        return nuXmvService;
    }

    public NuXmvExecService(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
    }

    public boolean executeModelChecking(String inputSmvFilePath, String resultFilePath, String alg_type, String check_type, String property, boolean isProgrExec, boolean internalExecution, String[] expression, final List<?> contextList) throws Exception {
        if (!isProgrExec) {
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    NuXmvExecService.this.dialog = new NuXmvParametersDialog(NuXmvExecService.this.abstractSystemModel, contextList);
                    NuXmvExecService.this.dialog.open();
                }
            });
            if (this.dialog.goAhead()) {
                alg_type = this.dialog.getAlgorithmType();
                check_type = this.dialog.getCheckType();
                property = this.dialog.getProperty();
            }
            if (expression != null) {
                expression[0] = String.valueOf(check_type) + "#" + property;
            }
        }
        if (alg_type != null & check_type != null & property != null) {
            return this.modelCheckingCommand(inputSmvFilePath, property, alg_type, check_type, resultFilePath, internalExecution);
        }
        return false;
    }

    public boolean modelCheckingCommand(String behaviour_model_filePath, String property, String alg_type, String check_type, String resultFilePath, boolean internalExecution) throws Exception {
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.behaviour.CheckModel";
        String ID_PARAMETER_BEHAVIOUR_MODEL = "behaviour_model";
        String ID_PARAMETER_PROPERTY = "property";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_PARAMETER_CHECK_TYPE = "check_type";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        String behaviour_model_Path = behaviour_model_filePath;
        CommandBuilder modelCheckingCommand = CommandBuilder.build((String)ID_COMMAND);
        modelCheckingCommand.setParameter(ID_PARAMETER_BEHAVIOUR_MODEL, behaviour_model_Path);
        modelCheckingCommand.setParameter(ID_PARAMETER_PROPERTY, property);
        modelCheckingCommand.setParameter(ID_PARAMETER_ALG_TYPE, alg_type);
        modelCheckingCommand.setParameter(ID_PARAMETER_CHECK_TYPE, check_type);
        modelCheckingCommand.setParameter(ID_PARAMETER_RESULT_FILE, resultFilePath);
        modelCheckingCommand.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
        Object objectResult = modelCheckingCommand.execute();
        if (objectResult != null && objectResult instanceof Request) {
            request = (Request)objectResult;
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }
}

