/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.ui.docGenerators;

import eu.fbk.eclipse.standardtools.diagram.ComponentDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DocumentGenerator;
import eu.fbk.eclipse.standardtools.diagram.PortDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ui.docGenerators.InternalBlockDiagramGeneratorService;
import eu.fbk.eclipse.standardtools.diagram.ui.model.AbstractInternalBlockDiagramModel;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class DocumentGeneratorService {
    AbstractInternalBlockDiagramModel graphicalModel;
    private static DocumentGeneratorService documentGeneratorService;
    private InternalBlockDiagramGeneratorService diagramGeneratorService;
    private String directoryName;
    private String imageExtension;
    private boolean showLeafComponents;

    public static DocumentGeneratorService getInstance(AbstractInternalBlockDiagramModel model) {
        if (documentGeneratorService == null) {
            documentGeneratorService = new DocumentGeneratorService(model);
        }
        return documentGeneratorService;
    }

    private DocumentGeneratorService(AbstractInternalBlockDiagramModel model) {
        this.diagramGeneratorService = InternalBlockDiagramGeneratorService.getInstance(this.graphicalModel);
        this.showLeafComponents = false;
        this.graphicalModel = model;
    }

    public void setParametersBeforeDocumentGeneration(boolean showPortLabels, boolean automaticLabelLayout, String directoryName, String imageExtension, boolean showLeafComponents) {
        this.diagramGeneratorService.setParametersBeforeDiagramGenerator(showPortLabels, automaticLabelLayout);
        this.imageExtension = imageExtension;
        this.directoryName = directoryName;
        this.showLeafComponents = showLeafComponents;
    }

    public void createDocumentFile(String currentProjectName, String docFormat, Object selectedGraphicalComponent, IProgressMonitor monitor) {
        monitor.beginTask("Creating Document File", 1);
        DocumentGenerator documentGenerator = new DocumentGenerator();
        documentGenerator.init(currentProjectName, docFormat);
        ContainerDescriptor rootDiagramDescriptor = this.createDiagramDescriptorWithDiagramAndComponentDescriptor(selectedGraphicalComponent, monitor);
        if (this.showLeafComponents) {
            this.enrichDiagramDescriptorWithSubComponentsInfo(selectedGraphicalComponent, rootDiagramDescriptor, monitor);
        }
        documentGenerator.setContainerDescriptor(rootDiagramDescriptor);
        documentGenerator.generate(this.directoryName);
        monitor.done();
    }

    private String getComponentImageFileName(Object component) {
        return String.valueOf(this.directoryName) + File.separator + this.graphicalModel.getGraphicalComponentName(component) + this.imageExtension;
    }

    private void enrichDiagramDescriptorWithSubComponentsInfo(Object parentComponent, ContainerDescriptor parentDescriptor, IProgressMonitor monitor) {
        for (Object component : this.graphicalModel.getGraphicalSubComponents(parentComponent)) {
            ContainerDescriptor diagramDescriptor = this.createDiagramDescriptorWithDiagramAndComponentDescriptor(component, monitor);
            parentDescriptor.children.add(diagramDescriptor);
            if (this.graphicalModel.getGraphicalSubComponents(component).isEmpty()) continue;
            this.enrichDiagramDescriptorWithSubComponentsInfo(component, diagramDescriptor, monitor);
        }
    }

    public ContainerDescriptor createDiagramDescriptorWithDiagramAndComponentDescriptor(Object component, IProgressMonitor monitor) {
        String saveFilePath = this.getComponentImageFileName(component);
        this.diagramGeneratorService.createDiagramFile(saveFilePath, component, monitor);
        String diagramName = this.graphicalModel.getGraphicalComponentName(component);
        ContainerDescriptor diagramDescriptor = this.diagramGeneratorService.createDiagramDescriptorWithImageFileUrl(diagramName, saveFilePath);
        diagramDescriptor.componentDescriptor = this.createComponentDescriptor(component);
        return diagramDescriptor;
    }

    private ComponentDescriptor createComponentDescriptor(Object component) {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.name = this.graphicalModel.getGraphicalComponentName(component);
        componentDescriptor.type = this.getComponentType(component);
        componentDescriptor.refinementType = this.getRefinementType(component);
        for (Object connector : this.graphicalModel.getGraphicalPorts(component)) {
            PortDescriptor descriptor = this.getPortDescriptor(component, connector);
            if (descriptor == null) continue;
            if (this.graphicalModel.isGraphicalInputPort(connector)) {
                componentDescriptor.inputPortDescriptors.add(descriptor);
                continue;
            }
            if (!this.graphicalModel.isGraphicalOutputPort(connector)) continue;
            componentDescriptor.outputPortDescriptors.add(descriptor);
        }
        return componentDescriptor;
    }

    private PortDescriptor getPortDescriptor(Object component, Object connector) {
        PortDescriptor descriptor = new PortDescriptor();
        descriptor.name = this.graphicalModel.getGraphicalPortName(connector);
        descriptor.type = this.getPortType(component, connector);
        descriptor.range = this.graphicalModel.getGraphicalPortRange(component, connector);
        descriptor.notes = "";
        if (this.graphicalModel.isGraphicalInputPort(connector)) {
            descriptor.direction = "input";
        } else if (this.graphicalModel.isGraphicalOutputPort(connector)) {
            descriptor.direction = "output";
        } else {
            return null;
        }
        return descriptor;
    }

    private String getPortType(Object component, Object port) {
        return this.graphicalModel.getGraphicalPortVariableType(port).toString();
    }

    private String getComponentType(Object component) {
        return "";
    }

    private String getRefinementType(Object component) {
        return "";
    }
}

