/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsToGraphics2DAdaptor;

public class SiriusDiagramImageGenerator
extends DiagramImageGenerator {
    public SiriusDiagramImageGenerator(DiagramEditPart dgrmEP) {
        super(dgrmEP);
    }

    public Image createAWTImageForParts(List selectedObjects, org.eclipse.swt.graphics.Rectangle sourceRect) {
        BufferedImage awtImage = null;
        IMapMode mm = this.getMapMode();
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.setX(sourceRect.x);
        rect.setY(sourceRect.y);
        rect.setWidth(sourceRect.width);
        rect.setHeight(sourceRect.height);
        mm.LPtoDP((Translatable)rect);
        awtImage = new BufferedImage((int)Math.round(rect.preciseWidth), (int)Math.rint(rect.preciseHeight), 7);
        Graphics2D g2d = awtImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, awtImage.getWidth(), awtImage.getHeight());
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore.getBoolean("Global.enableAntiAlias")) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d.clip(new Rectangle(0, 0, awtImage.getWidth(), awtImage.getHeight()));
        SiriusGraphicsToGraphics2DAdaptor graphics = new SiriusGraphicsToGraphics2DAdaptor(g2d, new org.eclipse.draw2d.geometry.Rectangle(0, 0, awtImage.getWidth(), awtImage.getHeight()));
        RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)graphics, mm);
        this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), selectedObjects);
        graphics.dispose();
        g2d.dispose();
        return awtImage;
    }
}

