/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.hierarchicalContractView.core.view;

import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeElements.RootNode;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeproviders.TreeContentProvider;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeproviders.TreeLabelProvider;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeproviders.TreeSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public abstract class HierarchicalView
extends ViewPart {
    public static String ID_PLUGIN = "eu.fbk.eclipse.standardtools.hierarchicalContractView.core";
    public static final int COLUMN_ELEMENT = 0;
    public static final int COLUMN_NUMBER = 1;
    private TreeViewer treeviewer;
    private Tree tree;
    private TreeColumn column0;
    private TreeColumn column1;
    private TreeSorter sorter;

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 2);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.column0 = new TreeColumn(this.tree, 0);
        this.column0.setText("System Architectures");
        this.column0.setWidth(300);
        this.column1 = new TreeColumn(this.tree, 0);
        this.column1.setText("Number of Subcomponents and Contracts");
        this.column1.setWidth(300);
        this.treeviewer = new TreeViewer(this.tree);
        this.sorter = new TreeSorter(this.treeviewer);
        this.sorter.addColumn(this.column0, 0);
        this.sorter.setSortColumnAndDirection(this.column0, this.sorter.isReverseSort() ? 1024 : 128);
        this.treeviewer.setComparator((ViewerComparator)this.sorter);
        this.treeviewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.updateView();
    }

    private void setTreeViewerInput(RootNode rootNode) {
        if (this.treeviewer != null && this.treeviewer.getTree() != null && !this.treeviewer.isBusy()) {
            this.treeviewer.setInput((Object)rootNode);
            this.treeviewer.refresh();
        }
    }

    public void updateView() {
        RootNode systems = this.getSystemObjects();
        if (systems != null) {
            this.setTreeViewerInput(systems);
        }
    }

    public void setFocus() {
        this.updateView();
    }

    public abstract RootNode getSystemObjects();
}

