/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.tests.support.api.SiriusTestCase;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public abstract class AbstractToolDescriptionTestCase
extends SiriusTestCase {
    protected void checkExpectedElementsInSelection(DialectEditor editor, List<String> objectsNameToCheck, int expectedSize) {
        this.checkExpectedElementsInSelection(editor, objectsNameToCheck, expectedSize, false);
    }

    protected void checkExpectedElementsInSelection(DialectEditor editor, List<String> objectsNameToCheck, int expectedSize, boolean semanticObjectName) {
        ArrayList selections = Lists.newArrayList((Iterable)DialectUIManager.INSTANCE.getSelection(editor));
        AbstractToolDescriptionTestCase.assertEquals((String)"Bad selection size, after tool execution.", (int)expectedSize, (int)selections.size());
        if (objectsNameToCheck != null) {
            int i = 0;
            while (i < objectsNameToCheck.size()) {
                String objectNameToCheck = objectsNameToCheck.get(i);
                String selectionName = "";
                if (semanticObjectName) {
                    EObject target = ((DSemanticDecorator)selections.get(i)).getTarget();
                    if (target != null) {
                        selectionName = target.toString();
                    }
                } else {
                    selectionName = ((DSemanticDecorator)selections.get(i)).toString();
                }
                AbstractToolDescriptionTestCase.assertTrue((String)("Bad selection after tool execution. Missing object :" + objectNameToCheck), (boolean)selectionName.contains(objectNameToCheck));
                ++i;
            }
        }
    }

    protected void changeSelectionExpression(final AbstractToolDescription tool, final String selectElementsExpression, final boolean inverseSelection) {
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                tool.setElementsToSelect(selectElementsExpression);
                tool.setInverseSelectionOrder(inverseSelection);
            }
        });
    }
}

