/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.utils;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;

public class PatternUtils {
    public static NamedElement applyStereotypes(NamedElement source, NamedElement target) {
        for (Stereotype stereo : source.getAppliedStereotypes()) {
            if (!target.isStereotypeApplicable(stereo)) continue;
            target.applyStereotype(stereo);
            EList attrs = stereo.getOwnedAttributes();
            for (Property property : attrs) {
                if (property.isReadOnly() || property.getName().startsWith("base_")) continue;
                Object srcValue = source.getValue(stereo, property.getName());
                target.setValue(stereo, property.getName(), srcValue);
            }
        }
        return target;
    }

    public static String StringListToString(List<String> list) {
        String result = "not available";
        if (list.size() > 0) {
            result = "";
            int i = 0;
            while (i < list.size()) {
                result = i > 0 ? String.valueOf(result) + "\n" + list.get(i) : String.valueOf(result) + list.get(i);
                ++i;
            }
        }
        return result;
    }

    public static Image retrieveImageforPatternPreview(Pattern pattern) {
        String preview = pattern.getPreview();
        if (preview != null) {
            String previewPath;
            String previewPlugin = preview.substring(0, preview.indexOf("/"));
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)previewPlugin, (String)(previewPath = preview.substring(preview.indexOf("/"))));
            if (imageDescriptor != null) {
                return imageDescriptor.createImage();
            }
            return null;
        }
        return null;
    }
}

