/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.patterns.dialogs.AbstractMappingDialog;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;

public class PropertyMappingDialog
extends AbstractMappingDialog {
    public PropertyMappingDialog(Shell shell, Model chessModel, Pattern pattern, Class modelCtx, Map<NamedElement, NamedElement> mappings, Image patternPreview) {
        super(shell, chessModel, modelCtx, pattern, patternPreview);
        this.mappings = mappings;
    }

    @Override
    public void create() {
        super.create();
        this.setMessage("Map Properties");
    }

    @Override
    protected List<NamedElement> getPatternInput() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        for (ConnectableElement collRole : this.pattern.getBase_Collaboration().getCollaborationRoles()) {
            if (!(collRole instanceof Property) || result.contains(collRole)) continue;
            result.add((NamedElement)collRole);
            this.mappings.put(collRole, null);
        }
        return result;
    }

    @Override
    protected void updateCandidates() {
        Class type = null;
        if (this.patternElem instanceof Property && ((Property)this.patternElem).getType() instanceof Class) {
            type = (Class)((Property)this.patternElem).getType();
        }
        if (type != null) {
            Class mappedType = null;
            boolean found = false;
            for (NamedElement key : this.mappings.keySet()) {
                if (!key.equals(type) || found) continue;
                mappedType = (Class)this.mappings.get(key);
                found = true;
            }
            if (mappedType != null) {
                for (Element elem : this.modelCtx.allOwnedElements()) {
                    Property prop;
                    if (!(elem instanceof Property) || elem instanceof Port || !(prop = (Property)elem).getType().equals(mappedType)) continue;
                    this.candidates.add(prop);
                }
            }
        }
    }
}

