/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.customization.palette.dialog.BundleIconExplorerDialog;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalDrawerProxy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DrawerInformationPage
extends WizardPage
implements Listener {
    protected Text nameText;
    protected Text idText;
    protected Composite advancedComposite;
    protected Button advancedButton;
    protected String drawerID;
    protected String name;
    protected String imageDescriptorPath;
    protected Text imageText;
    protected final PaletteLocalDrawerProxy drawerProxy;
    protected static final String WIZARD_ICON = "/icons/new_drawer_wiz.gif";

    public DrawerInformationPage() {
        super(Messages.Wizard_Drawer_Page_Name, Messages.Wizard_Drawer_Page_Title, Activator.getImageDescriptor((String)WIZARD_ICON));
        this.drawerProxy = null;
    }

    public DrawerInformationPage(PaletteLocalDrawerProxy drawerProxy) {
        super(Messages.Wizard_Drawer_Page_Name, Messages.Wizard_Drawer_Page_Title, Activator.getImageDescriptor((String)WIZARD_ICON));
        this.drawerProxy = drawerProxy;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.intializeValues();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.createNameControl(control);
        this.createAdvancedControls(control);
        Dialog.applyDialogFont((Control)control);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(false);
        this.setControl((Control)control);
    }

    protected void intializeValues() {
        this.initName();
        this.initDrawerID();
        this.initImageDescriptor();
    }

    public String getDrawerName() {
        return this.name;
    }

    public String getDrawerID() {
        return this.drawerID;
    }

    public String getImageDescriptorPath() {
        return this.imageDescriptorPath;
    }

    protected void initName() {
        this.name = this.drawerProxy == null ? "" : this.drawerProxy.getLabel();
    }

    protected void initDrawerID() {
        this.drawerID = this.drawerProxy == null ? "drawer_" + System.currentTimeMillis() : this.drawerProxy.getId();
    }

    protected void initImageDescriptor() {
        this.imageDescriptorPath = this.drawerProxy == null ? "/icons/drawer.gif" : this.drawerProxy.getImagePath();
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (this.advancedComposite != null && !this.advancedComposite.isDisposed()) {
            if ("".equals(this.getDrawerID())) {
                this.setErrorMessage(Messages.Wizard_Drawer_Error_Id);
                valid = false;
            } else if ("".equals(this.getImageDescriptorPath())) {
                this.setErrorMessage(Messages.Wizard_Drawer_Error_Icon);
                valid = false;
            }
        }
        if ("".equals(this.getDrawerName())) {
            this.setErrorMessage(Messages.Wizard_Drawer_Error_Name);
            valid = false;
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    protected void createAdvancedControls(Composite parent) {
        this.advancedButton = new Button(parent, 8);
        this.advancedButton.setFont(parent.getFont());
        this.advancedButton.setText(Messages.Dialog_Advanced_Button_Closed);
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        data.horizontalSpan = 2;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrawerInformationPage.this.handleAdvancedButtonSelect();
            }
        });
    }

    public Composite createAdvancedComposite(Composite parent) {
        this.advancedComposite = new Composite(parent, 0);
        this.advancedComposite.setFont(parent.getFont());
        this.advancedComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.advancedComposite.setLayout((Layout)layout);
        this.createIconControl(this.advancedComposite);
        this.createIDControl(this.advancedComposite);
        this.advancedComposite.getParent().layout();
        return this.advancedComposite;
    }

    protected void createIconControl(final Composite composite) {
        Label iconLabel = new Label(composite, 0);
        iconLabel.setText(Messages.Wizard_Drawer_Icon);
        iconLabel.setToolTipText(Messages.Wizard_Drawer_Icon_Tooltip);
        this.imageText = new Text(composite, 2056);
        this.imageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.imageText.setToolTipText(Messages.Wizard_Drawer_Icon_Tooltip);
        this.initialPopulateDrawerIconField();
        Button button = new Button(composite, 0);
        button.setText("...");
        button.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                BundleIconExplorerDialog dialog = new BundleIconExplorerDialog(composite.getShell(), DrawerInformationPage.this.imageText.getText());
                if (dialog.open() == 0) {
                    Object[] values = dialog.getResult();
                    if (values.length != 1) {
                        Activator.log.error("Waiting one icon path, but found " + values.length, null);
                    } else {
                        DrawerInformationPage.this.imageDescriptorPath = values[0].toString();
                        DrawerInformationPage.this.imageText.setText(DrawerInformationPage.this.imageDescriptorPath);
                    }
                }
                DrawerInformationPage.this.setPageComplete(DrawerInformationPage.this.validatePage());
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void handleAdvancedButtonSelect() {
        Composite composite = (Composite)this.getControl();
        if (this.advancedComposite != null) {
            this.advancedComposite.dispose();
            this.advancedComposite = null;
            this.advancedButton.setText(Messages.Dialog_Advanced_Button_Closed);
        } else {
            this.createAdvancedComposite(composite);
            this.advancedButton.setText(Messages.Dialog_Advanced_Button_Opened);
        }
    }

    protected void createIDControl(Composite control) {
        Label idLabel = new Label(control, 0);
        idLabel.setText(Messages.Wizard_Drawer_Id);
        idLabel.setToolTipText(Messages.Wizard_Drawer_Id_Tooltip);
        this.idText = new Text(control, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.idText.setLayoutData((Object)data);
        this.idText.setToolTipText(Messages.Wizard_Drawer_Id_Tooltip);
        this.initialPopulateDrawerIDField();
        this.idText.addListener(24, (Listener)this);
    }

    protected void initialPopulateDrawerIconField() {
        this.imageText.setText(this.imageDescriptorPath);
    }

    protected void initialPopulateDrawerIDField() {
        this.idText.setText(this.drawerID);
    }

    protected void createNameControl(Composite control) {
        Label nameLabel = new Label(control, 0);
        nameLabel.setText(Messages.Wizard_Drawer_Name);
        nameLabel.setToolTipText(Messages.Wizard_Drawer_Name_Tooltip);
        this.nameText = new Text(control, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setToolTipText(Messages.Wizard_Drawer_Name_Tooltip);
        this.initialPopulateNameField();
        this.nameText.addListener(24, (Listener)this);
    }

    protected void initialPopulateNameField() {
        this.nameText.setText(this.name);
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget.equals(this.nameText)) {
            this.name = this.nameText.getText();
        } else if (widget.equals(this.idText)) {
            this.drawerID = this.idText.getText();
        }
        this.setPageComplete(this.validatePage());
    }
}

