/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class LogHelper {
    private final Plugin myPlugin;
    private final String myId;
    private final ILog myLog;

    public LogHelper(Plugin plugin) {
        this(plugin, plugin.getBundle().getSymbolicName());
    }

    public LogHelper(Plugin plugin, String bundleID) {
        this.myPlugin = plugin;
        this.myId = bundleID;
        this.myLog = this.myPlugin.getLog();
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.myLog.log((IStatus)new Status(4, this.myId, LogHelper.notNull(error), throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.myLog.log((IStatus)new Status(1, this.myId, LogHelper.notNull(message), throwable));
        this.debug(message, throwable);
    }

    public void logStatus(IStatus status) {
        this.myLog.log(status);
    }

    private static String notNull(String text) {
        return text == null ? "" : text;
    }

    private void debug(String message, Throwable throwable) {
        if (!this.myPlugin.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

