/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.rules;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.core.AbstractRule;
import org.eclipse.papyrus.uml.types.core.requests.ApplyProfileRequest;
import org.eclipse.papyrus.uml.types.core.requests.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.types.core.requests.SetStereotypeValueRequest;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyProfileRequest;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyStereotypeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUmlRule<T extends RuleConfiguration>
extends AbstractRule<T> {
    protected T invariantRuleConfiguration;

    public boolean approveRequest(IEditCommandRequest request) {
        List elementsToEdit = request.getElementsToEdit();
        for (Object elementToEdit : elementsToEdit) {
            IElementType[] types;
            if (!(elementToEdit instanceof EObject)) continue;
            IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)elementToEdit, request.getClientContext());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IElementType type = iElementTypeArray[n2];
                if (type instanceof ConfiguredHintedSpecializationElementType) {
                    ConfiguredHintedSpecializationElementType configuredHintedSpecializationElementType = (ConfiguredHintedSpecializationElementType)type;
                    if (request instanceof ApplyStereotypeRequest ? !this.approveApplyStereotypeRequest(configuredHintedSpecializationElementType, (ApplyStereotypeRequest)request) : (request instanceof UnapplyStereotypeRequest ? !this.approveUnapplyStereotypeRequest(configuredHintedSpecializationElementType, (UnapplyStereotypeRequest)request) : (request instanceof ApplyProfileRequest ? !this.approveApplyProfileRequest(configuredHintedSpecializationElementType, (ApplyProfileRequest)request) : (request instanceof UnapplyProfileRequest ? !this.approveUnapplyProfileRequest(configuredHintedSpecializationElementType, (UnapplyProfileRequest)request) : request instanceof SetStereotypeValueRequest && !this.approveSetStereotypeValueRequest(configuredHintedSpecializationElementType, (SetStereotypeValueRequest)request))))) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return super.approveRequest(request);
    }

    protected abstract boolean approveApplyStereotypeRequest(ConfiguredHintedSpecializationElementType var1, ApplyStereotypeRequest var2);

    protected abstract boolean approveUnapplyStereotypeRequest(ConfiguredHintedSpecializationElementType var1, UnapplyStereotypeRequest var2);

    protected abstract boolean approveApplyProfileRequest(ConfiguredHintedSpecializationElementType var1, ApplyProfileRequest var2);

    protected abstract boolean approveUnapplyProfileRequest(ConfiguredHintedSpecializationElementType var1, UnapplyProfileRequest var2);

    protected abstract boolean approveSetStereotypeValueRequest(ConfiguredHintedSpecializationElementType var1, SetStereotypeValueRequest var2);

    public void init(T invariantRuleConfiguration) {
        this.invariantRuleConfiguration = invariantRuleConfiguration;
    }
}

