/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.sirius.common.ui.tools.api.util.ISaveDialogExtension;
import org.eclipse.sirius.common.ui.tools.internal.util.ISaveDialogExtensionDescriptor;

public final class ISaveDialogExtensionRegistry {
    private static final Map<ISaveDialogExtension, Collection<ISaveDialogExtensionDescriptor>> EXTENSIONS = Maps.newHashMap();

    private ISaveDialogExtensionRegistry() {
    }

    public static void addExtension(ISaveDialogExtensionDescriptor extension) {
        ISaveDialogExtension behavior = extension.getSaveDialogExtension();
        if (EXTENSIONS.get(behavior) == null) {
            EXTENSIONS.put(behavior, new HashSet());
        }
        EXTENSIONS.get(behavior).add(extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<ISaveDialogExtensionDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<ISaveDialogExtensionDescriptor> extensions : EXTENSIONS.values()) {
            registeredExtensions.addAll(extensions);
        }
        return registeredExtensions;
    }

    public static void removeExtension(String extensionClassName) {
        for (ISaveDialogExtensionDescriptor extension : ISaveDialogExtensionRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.get(extension.getSaveDialogExtension()).clear();
        }
    }
}

