/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.core.internal.clipboard.CopierFactory;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class DefaultPasteCommand
extends AbstractCommand {
    protected EObject targetOwner;
    protected CompositeCommand command;

    public DefaultPasteCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard papyrusClipboard) {
        this.targetOwner = targetOwner;
        if (papyrusClipboard.size() > 0) {
            ArrayList<EObject> eobjectsTopaste = new ArrayList<EObject>();
            for (Object object : papyrusClipboard) {
                if (!(object instanceof EObject)) continue;
                eobjectsTopaste.add((EObject)object);
            }
            List rootElementToPaste = EcoreUtil.filterDescendants(eobjectsTopaste);
            EcoreUtil.Copier copier = new CopierFactory(domain.getResourceSet()).get();
            copier.copyAll((Collection)rootElementToPaste);
            copier.copyReferences();
            HashMap duplicatedObjects = new HashMap();
            duplicatedObjects.putAll(copier);
            papyrusClipboard.addAllInternalToTargetCopy(duplicatedObjects);
            ArrayList<EObject> objectsToMove = new ArrayList<EObject>();
            for (EObject eObject : rootElementToPaste) {
                EObject copyObject = (EObject)duplicatedObjects.get(eObject);
                if (copyObject == null) continue;
                objectsToMove.add(copyObject);
            }
            List rootObjectsToMove = EcoreUtil.filterDescendants(objectsToMove);
            for (EObject eObject : rootObjectsToMove) {
                ICommand editCommand;
                MoveRequest moveRequest = new MoveRequest(targetOwner, eObject);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
                if (provider == null || (editCommand = provider.getEditCommand((IEditCommandRequest)moveRequest)) == null || !editCommand.canExecute()) continue;
                this.getCommand().compose((IUndoableOperation)editCommand);
            }
        }
    }

    public CompositeCommand getCommand() {
        if (this.command == null) {
            this.command = new CompositeCommand("Paste All Object");
        }
        return this.command;
    }

    public void execute() {
        if (this.command != null) {
            try {
                this.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public boolean canExecute() {
        if (this.command == null) {
            return true;
        }
        return this.command.canExecute();
    }

    public void redo() {
        if (this.command != null) {
            try {
                this.command.redo((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void undo() {
        if (this.command != null) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.command.undo((IProgressMonitor)monitor, null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }
}

