/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.eclipse.finder.waits.WaitForEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.gef.finder.matchers.IsInstanceOf;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.waits.WaitForObjectCondition;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class SWTBotSiriusHelper {
    private static SWTWorkbenchBot bot = new SWTWorkbenchBot();

    private SWTBotSiriusHelper() {
    }

    public static Option<String> getPropertyItemTitle() {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(TabbedPropertyTitle.class)});
        final List widgets = SWTBotSiriusHelper.widget(matcher);
        String result = (String)UIThreadRunnable.syncExec((Display)SWTUtils.display(), (Result)new StringResult(){

            public String run() {
                for (TabbedPropertyTitle tabbedProperty : widgets) {
                    Option title = ReflectionHelper.getFieldValueWithoutException((Object)tabbedProperty, (String)"text");
                    if (!title.some()) continue;
                    return (String)title.get();
                }
                return null;
            }
        });
        return Options.newSome((Object)result);
    }

    public static boolean selectPropertyTabItem(final String label) {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(TabbedPropertyList.class)});
        final List widgets = SWTBotSiriusHelper.widget(matcher);
        Boolean result = (Boolean)UIThreadRunnable.syncExec((Display)SWTUtils.display(), (Result)new BoolResult(){

            public Boolean run() {
                boolean result = false;
                for (TabbedPropertyList tabbedProperty : widgets) {
                    TabbedPropertyList.ListElement tabItem = SWTBotSiriusHelper.getTabItem(label, tabbedProperty);
                    if (tabItem == null) continue;
                    Event mouseEvent = SWTBotSiriusHelper.createEvent((Widget)tabItem, tabItem.getBounds().x, tabItem.getBounds().y, 1, 524288, 1);
                    tabItem.notifyListeners(4, mouseEvent);
                    result = true;
                    break;
                }
                return result;
            }
        });
        return result != null ? result : false;
    }

    public static <T extends Widget> List<T> widget(Matcher<T> matcher) {
        WaitForObjectCondition waitForWidget = org.eclipse.swtbot.swt.finder.waits.Conditions.waitForWidget(matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForWidget);
        return waitForWidget.getAllMatches();
    }

    private static Event createEvent(Widget widget, int x, int y, int button, int stateMask, int count) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = bot.getDisplay();
        event.x = x;
        event.y = y;
        event.button = button;
        event.stateMask = stateMask;
        event.count = count;
        return event;
    }

    private static TabbedPropertyList.ListElement getTabItem(String label, TabbedPropertyList tabbedProperty) {
        Control[] controlArray = tabbedProperty.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control listElement = controlArray[n2];
            if (listElement instanceof TabbedPropertyList.ListElement && ((TabbedPropertyList.ListElement)listElement).getTabItem().getText().equals(label)) {
                return (TabbedPropertyList.ListElement)listElement;
            }
            ++n2;
        }
        return null;
    }

    public static SWTBotEditor getSiriusEditor(String fileName) throws WidgetNotFoundException {
        bot.editorByTitle(fileName).show();
        return SWTBotSiriusHelper.getSiriusEditor(fileName, 0);
    }

    public static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(String fileName) throws WidgetNotFoundException {
        bot.editorByTitle(fileName).show();
        return SWTBotSiriusHelper.getSiriusDiagramEditor(fileName, 0);
    }

    public static SWTBotSiriusDiagramEditor getDesignerEditorContainingName(String partialFileName) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((Matcher)Matchers.containsString((String)partialFileName));
        return SWTBotSiriusHelper.getSiriusDiagramEditor((Matcher<IEditorReference>)withPartName, 0);
    }

    public static SWTBotEditor getDiagramDialectEditorBot(String title) {
        SWTBotEditor swtBotEditor = SWTBotSiriusHelper.getDiagramDialectEditorBots(title).get(0);
        return swtBotEditor;
    }

    public static List<SWTBotEditor> getDiagramDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> diagramDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DDiagramEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, bot);
            diagramDialectEditorBots.add(swtBotEditor);
        }
        return diagramDialectEditorBots;
    }

    public static SWTBotEditor getTreeDialectEditorBot(String title) {
        bot.editorByTitle(title).show();
        SWTBotEditor swtBotEditor = SWTBotSiriusHelper.getTreeDialectEditorBots(title).get(0);
        return swtBotEditor;
    }

    public static List<SWTBotEditor> getTreeDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> treeDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DTreeEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, bot);
            treeDialectEditorBots.add(swtBotEditor);
        }
        return treeDialectEditorBots;
    }

    public static SWTBotEditor getTableDialectEditorBot(String title) {
        bot.editorByTitle(title).show();
        SWTBotEditor swtBotEditor = SWTBotSiriusHelper.getTableDialectEditorBots(title).get(0);
        return swtBotEditor;
    }

    public static List<SWTBotEditor> getTableDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> tableDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DTableEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, bot);
            tableDialectEditorBots.add(swtBotEditor);
        }
        return tableDialectEditorBots;
    }

    public static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(String fileName, int index) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)fileName);
        return SWTBotSiriusHelper.getSiriusDiagramEditor((Matcher<IEditorReference>)withPartName, index);
    }

    private static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(Matcher<IEditorReference> withPartName, int index) throws WidgetNotFoundException {
        SWTBotSiriusDiagramEditor swtBotDesignerEditor = null;
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForEditor);
        IEditorReference editorReference = (IEditorReference)waitForEditor.get(index);
        if (editorReference.getEditor(false) instanceof DialectEditor) {
            swtBotDesignerEditor = new SWTBotSiriusDiagramEditor((IEditorReference)waitForEditor.get(index), bot);
        }
        return swtBotDesignerEditor;
    }

    public static SWTBotEditor getSiriusEditor(String fileName, int index) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)fileName);
        return SWTBotSiriusHelper.getSiriusEditor((Matcher<IEditorReference>)withPartName, index);
    }

    private static SWTBotEditor getSiriusEditor(Matcher<IEditorReference> withPartName, int index) throws WidgetNotFoundException {
        SWTBotEditor swtBotSiriusEditor = null;
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        bot.waitUntilWidgetAppears((ICondition)waitForEditor);
        IEditorReference editorReference = (IEditorReference)waitForEditor.get(index);
        if (editorReference.getEditor(false) instanceof DialectEditor) {
            swtBotSiriusEditor = new SWTBotEditor((IEditorReference)waitForEditor.get(index), bot);
        }
        return swtBotSiriusEditor;
    }

    public static void close(final SWTBotEditor swtBotEditor, final boolean save) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                ((IEditorReference)swtBotEditor.getReference()).getPage().closeEditor(((IEditorReference)swtBotEditor.getReference()).getEditor(false), save);
            }
        });
    }

    public static void closeAllEditors(final boolean save) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                List editors = bot.editors();
                for (SWTBotEditor swtBotEditor : editors) {
                    ((IEditorReference)swtBotEditor.getReference()).getPage().closeEditor(((IEditorReference)swtBotEditor.getReference()).getEditor(false), save);
                }
            }
        });
    }
}

