/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.core.utils;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;

public class SysMLElementExtractor {
    private AbstractSystemModel abstractSystemModel;
    private Collection<?> callEvents;
    private BasicEMap<String, Boolean> declaredVariablesInCurrentBlockCache;
    public boolean checkAttributesDeclaration;
    private HashMap<String, Object> globalVariableCache;
    private EList<String> attributesInCurrentBlock;
    private EList<String> operationsInCurrentBlock;
    private EList<String> commandArguments;
    private EList<String> currOperationArguments;
    private List<?> blocksAsClasses;
    private Object currBlock;
    private Object currOperationType;
    private String currOperationName;
    private Object currOperation;

    public SysMLElementExtractor(AbstractSystemModel abstractSystemModel, Object currBlock, List<?> blocksAsClasses) {
        this.abstractSystemModel = abstractSystemModel;
        this.checkAttributesDeclaration = true;
        this.declaredVariablesInCurrentBlockCache = new BasicEMap();
        this.globalVariableCache = this.initGlobalVariablesCache();
        this.commandArguments = new BasicEList();
        this.currOperationArguments = new BasicEList();
        this.blocksAsClasses = blocksAsClasses;
        this.currBlock = currBlock;
        if (abstractSystemModel != null) {
            this.callEvents = abstractSystemModel.getAllCallEvent(currBlock);
            this.attributesInCurrentBlock = abstractSystemModel.getAttributesNames(currBlock);
            this.operationsInCurrentBlock = abstractSystemModel.getOperationsNames(currBlock);
        }
    }

    public boolean isOperationArgument(String argument) {
        return this.currOperationArguments.contains((Object)argument);
    }

    public Object getGlobalVariableTypeFromCache(String object) throws Exception {
        return this.globalVariableCache.get(object);
    }

    private HashMap<String, Object> initGlobalVariablesCache() {
        return new HashMap<String, Object>();
    }

    public void addAllVariableInGlobalVariablesCache(HashMap<String, Object> typeAssignmentCache) {
        this.globalVariableCache.putAll(typeAssignmentCache);
    }

    public boolean isCommandOperation(String methodName, Object blockType) {
        return this.abstractSystemModel.isCommandOperation(methodName, blockType);
    }

    public Object getCallEvent(String callEventName) throws Exception {
        for (Object callEvent : this.callEvents) {
            String currCallEventName = this.abstractSystemModel.getCallEventName(callEvent);
            if (!currCallEventName.equals(callEventName)) continue;
            return callEvent;
        }
        return null;
    }

    public String getCallEventOperationName(String eventName) throws Exception {
        Object callEvent = this.getCallEvent(eventName);
        String operationName = this.abstractSystemModel.getCallEventOperationName(callEvent);
        return operationName;
    }

    public Object getAttributeOrOperationType(String attributeOrOperationOrCallEventName) throws Exception {
        return this.getAttributeOrOperationType(attributeOrOperationOrCallEventName, this.currBlock);
    }

    public Object isAttributeType(String attributeOrOperationOrCallEventName, Object blockOrCallEvent) throws Exception {
        if (this.abstractSystemModel.getAttributeType(attributeOrOperationOrCallEventName, blockOrCallEvent) != null) {
            return true;
        }
        return false;
    }

    public Object getAttributeOrOperationType(String attributeOrOperationOrCallEventName, Object blockOrCallEvent) throws Exception {
        if (this.abstractSystemModel.isCallEvent(blockOrCallEvent)) {
            Object callEventParameterType = this.abstractSystemModel.getCallEventParameterType(attributeOrOperationOrCallEventName, blockOrCallEvent);
            return callEventParameterType;
        }
        if (this.abstractSystemModel.isBlockType(blockOrCallEvent)) {
            Object attrType = this.abstractSystemModel.getAttributeType(attributeOrOperationOrCallEventName, blockOrCallEvent);
            if (attrType != null) {
                return attrType;
            }
            Object opType = this.abstractSystemModel.getOperationReturnType(attributeOrOperationOrCallEventName, blockOrCallEvent);
            if (opType != null) {
                return opType;
            }
            Object callEvent = this.getCallEvent(attributeOrOperationOrCallEventName);
            if (callEvent != null) {
                return callEvent;
            }
            throw new Exception("The type is null for attribute or operation: " + attributeOrOperationOrCallEventName + " in block: " + blockOrCallEvent);
        }
        Exception e = new Exception("The element of '" + blockOrCallEvent + "' is not a block or a CallEvent");
        e.printStackTrace();
        throw e;
    }

    public boolean isCallEvent(String idName) throws Exception {
        if (this.callEvents != null) {
            for (Object callEvent : this.callEvents) {
                String callEventName = this.abstractSystemModel.getCallEventName(callEvent);
                if (!callEventName.equals(idName)) continue;
                return true;
            }
        }
        return false;
    }

    public Object retrieveBlockType(String identifierName, Object currBlock) throws Exception {
        Object block = currBlock;
        if (!this.abstractSystemModel.isBlockTypeAttribute(identifierName, block)) {
            throw new Exception("No attribute with name " + identifierName + " of type Block is found in " + this.abstractSystemModel.getComponentName(block));
        }
        block = this.abstractSystemModel.getAttributeBlockType(identifierName, block);
        if (block == null) {
            throw new Exception("block type not found for element " + identifierName + " in current block " + currBlock);
        }
        return block;
    }

    public String getCurrOperationEnumTypeName() {
        return this.getEnumTypeName(this.currOperationType);
    }

    public Object getCurrOperationEnumType() {
        return this.currOperationType;
    }

    public Object getCurrOperationType() {
        return this.currOperationType;
    }

    public String getEnumTypeName(Object enumType) {
        String res = this.abstractSystemModel.getName(enumType);
        return res;
    }

    public boolean isGloballyDeclared(String variableName) {
        return this.globalVariableCache.containsKey(variableName);
    }

    public boolean isDeclaredInCurrentBlock(String variableName) {
        if (this.declaredVariablesInCurrentBlockCache.contains((Object)variableName)) {
            return (Boolean)this.declaredVariablesInCurrentBlockCache.get((Object)variableName);
        }
        boolean isDeclared = this.checkAttributesDeclaration && this.attributesInCurrentBlock.contains((Object)variableName) || this.checkAttributesDeclaration && this.operationsInCurrentBlock.contains((Object)variableName) || this.globalVariableCache.containsKey(variableName);
        this.declaredVariablesInCurrentBlockCache.put((Object)variableName, (Object)isDeclared);
        return isDeclared;
    }

    public void setOperationInfo(String operationName, EList<String> commandArguments, EList<String> currOperationArguments, Object returnType) {
        this.currOperationName = operationName;
        if (commandArguments != null) {
            this.commandArguments = commandArguments;
        } else {
            this.commandArguments.clear();
        }
        if (currOperationArguments != null) {
            this.currOperationArguments = currOperationArguments;
        } else {
            this.currOperationArguments.clear();
        }
        this.currOperationType = returnType;
    }

    public void setOperationInfo(Object operation, String operationName, EList<String> commandArguments, EList<String> currOperationArguments, Object returnType) {
        this.currOperation = operation;
        this.setOperationInfo(operationName, commandArguments, currOperationArguments, returnType);
    }

    public boolean isCommandArgument(String argName) {
        return this.commandArguments != null && this.commandArguments.contains((Object)argName);
    }

    public Object getBlockType(String blockTypeName) throws Exception {
        Object blockType = this.getBlockType(blockTypeName, this.blocksAsClasses);
        if (blockType == null) {
            throw new Exception("Current block : " + this.currBlock + ". Block with name " + blockTypeName + " not found in the list of blocks.");
        }
        return blockType;
    }

    private Object getBlockType(String blockTypeName, List<?> blocksAsClasses) {
        for (Object currBlock : blocksAsClasses) {
            String currBlockName = this.abstractSystemModel.getComponentName(currBlock);
            if (!currBlockName.equals(blockTypeName)) continue;
            return currBlock;
        }
        return null;
    }

    public boolean isEnumLiteralInCurrOperation(String literalName) {
        return this.isEnumLiteral(literalName, this.currOperationType);
    }

    public boolean isEnumLiteral(String literalName, Object enumType) {
        if (this.abstractSystemModel.isEnumType(enumType)) {
            String[] stringArray = this.abstractSystemModel.getValuesForEnumeratorType(enumType);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String values = stringArray[n2];
                if (values.equalsIgnoreCase(literalName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Object getArgumentType(int argIndex, String methodName, Object blockType) {
        return this.abstractSystemModel.getParameterType(argIndex, methodName, blockType);
    }

    public Object getArgumentType(String argName, String methodName, Object blockType) {
        return this.abstractSystemModel.getParameterType(argName, methodName, blockType);
    }

    public Object getArgumentTypeOfCurrOperation(String argName) {
        return this.abstractSystemModel.getParameterType(argName, this.currOperationName, this.currBlock);
    }

    public boolean isAttribute(String attributeName, Object block) {
        return this.abstractSystemModel.isAttribute(attributeName, block);
    }

    public Object getAttributeType(String attributeName, Object block) {
        return this.abstractSystemModel.getAttributeType(attributeName, block);
    }

    public boolean isOperation(String operationName, Object block) {
        return this.abstractSystemModel.isOperation(operationName, block);
    }

    public Object getOperationReturnType(String variableName, Object block) {
        return this.abstractSystemModel.getOperationReturnType(variableName, block);
    }

    public Object getCurrBlock() {
        return this.currBlock;
    }

    public Object getCurrOperation() {
        return this.currOperation;
    }

    public void setCheckAttributesDeclaration(boolean checkAttributesDeclaration) {
        this.checkAttributesDeclaration = checkAttributesDeclaration;
    }

    public String getCurrOperationName() {
        return this.currOperationName;
    }
}

