/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.core.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class EObjectExtractor {
    private static final Logger logger = Logger.getLogger(EObjectExtractor.class);
    private HashMap<EObject, HashMap<String, Object>> declIteratorsCache = this.initIteratorsCache();
    private HashMap<EObject, String> tempVarsCache = this.initTempVarsCache();
    private int tempVarCounter = 0;
    private List<String> literalsNamesMap;

    public EObjectExtractor(EObject o, List<String> literalsNamesMap) {
        this.literalsNamesMap = literalsNamesMap;
        this.initDeclIterators(o);
    }

    private HashMap<EObject, String> initTempVarsCache() {
        return new HashMap<EObject, String>();
    }

    public HashMap<String, Object> getDeclIterVariableFromLocalCache(EObject o) {
        return this.declIteratorsCache.get(o);
    }

    public void initDeclIterators(EObject o) {
        this.putDeclIterVariableInLocalCache(o, new HashMap<String, Object>());
    }

    public void putDeclIterVariableInLocalCache(EObject key, HashMap<String, Object> variableInfo) {
        this.declIteratorsCache.put(key, variableInfo);
    }

    public String returnLiteralName(String literal) throws Exception {
        for (String currLiteral : this.literalsNamesMap) {
            if (!currLiteral.equalsIgnoreCase(literal)) continue;
            return currLiteral;
        }
        throw new Exception("Literal '" + literal + "' not found in the model");
    }

    public Object getIteratorType(EObject eObject, String variableName) {
        return this.declIteratorsCache.get(eObject).get(variableName);
    }

    public HashMap<EObject, HashMap<String, Object>> initIteratorsCache() {
        return new HashMap<EObject, HashMap<String, Object>>();
    }

    public boolean isDeclatredIterator(EObject eObj, String itName) {
        return this.declIteratorsCache.containsKey(eObj) && this.declIteratorsCache.get(eObj) != null && this.declIteratorsCache.get(eObj).containsKey(itName);
    }

    public HashMap<EObject, HashMap<String, Object>> getDeclIteratorsCache() {
        return this.declIteratorsCache;
    }

    public HashMap<EObject, String> getTempVarsCache() {
        return this.tempVarsCache;
    }

    public void putTempVarIndInLocalCache(EObject key, String index) {
        this.tempVarsCache.put(key, index);
    }

    public void setTempVarIndex(EObject key, String prefix) {
        this.putTempVarIndInLocalCache(key, String.valueOf(prefix) + "_" + String.valueOf(this.tempVarCounter));
        ++this.tempVarCounter;
    }

    public Object getTempVarInd(EObject eObject) {
        return this.tempVarsCache.get(eObject);
    }

    public void printElements() {
        logger.trace((Object)"printElements");
        for (Map.Entry<EObject, HashMap<String, Object>> elem : this.declIteratorsCache.entrySet()) {
            if (elem.getValue() == null) continue;
            for (Map.Entry<String, Object> entry : elem.getValue().entrySet()) {
                logger.trace((Object)(elem.getKey() + " 1. elem: " + entry.getValue()));
            }
        }
    }

    public String getTermVarName(EObject o) {
        if (this.tempVarsCache.containsKey(o)) {
            return "res_" + this.getTempVarInd(o);
        }
        return null;
    }
}

