/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.es2as;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.JavaCompareToOperation;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class Ecore2ASReferenceSwitch
extends EcoreSwitch<Object> {
    private static final Logger logger = Logger.getLogger(Ecore2ASReferenceSwitch.class);
    public static final String PROPERTY_OPPOSITE_ROLE_NAME_KEY = "Property.oppositeRoleName";
    public static final Object PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY = "Property.oppositeUnique";
    public static final Object PROPERTY_OPPOSITE_ROLE_ORDERED_KEY = "Property.oppositeOrdered";
    public static final Object PROPERTY_OPPOSITE_ROLE_LOWER_KEY = "Property.oppositeLower";
    public static final Object PROPERTY_OPPOSITE_ROLE_UPPER_KEY = "Property.oppositeUpper";
    protected final @NonNull Ecore2AS converter;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull StandardLibraryInternal standardLibrary;

    public Ecore2ASReferenceSwitch(@NonNull Ecore2AS converter) {
        this.converter = converter;
        this.metamodelManager = converter.getMetamodelManager();
        this.standardLibrary = this.metamodelManager.getStandardLibrary();
    }

    public Object caseEAnnotation(EAnnotation eObject) {
        @NonNull EAnnotation eObject2 = eObject;
        Annotation pivotElement = this.converter.getCreated(Annotation.class, (EObject)eObject2);
        if (pivotElement != null) {
            this.doSwitchAll(Element.class, ClassUtil.nullFree(pivotElement.getReferences()), (List<? extends EObject>)eObject2.getReferences());
        }
        return null;
    }

    public Object caseEClass(EClass eObject) {
        @NonNull EClass eObject2 = eObject;
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eObject2);
        if (pivotElement != null) {
            this.doSwitchAll(Class.class, ClassUtil.nullFree(pivotElement.getSuperClasses()), (List<? extends EObject>)eObject2.getEGenericSuperTypes());
            if (pivotElement.getSuperClasses().isEmpty()) {
                Class oclElementType = this.standardLibrary.getOclElementType();
                pivotElement.getSuperClasses().add(oclElementType);
            }
        }
        return null;
    }

    public Object caseEDataType(EDataType eObject) {
        java.lang.Class instanceClass;
        @NonNull EDataType eObject2 = eObject;
        DataType pivotElement = this.converter.getCreated(DataType.class, (EObject)eObject2);
        if (pivotElement != null && (instanceClass = eObject2.getInstanceClass()) != null) {
            try {
                Method declaredMethod = instanceClass.getDeclaredMethod("compareTo", instanceClass);
                if (declaredMethod != null) {
                    Operation operation = PivotFactory.eINSTANCE.createOperation();
                    operation.setName("compareTo");
                    operation.setImplementation(new JavaCompareToOperation(declaredMethod));
                    Parameter parameter = PivotFactory.eINSTANCE.createParameter();
                    parameter.setName("that");
                    parameter.setType(this.standardLibrary.getOclSelfType());
                    operation.getOwnedParameters().add(parameter);
                    operation.setType(this.standardLibrary.getIntegerType());
                    pivotElement.getOwnedOperations().add(operation);
                    pivotElement.getSuperClasses().add(this.standardLibrary.getOclComparableType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object caseEEnum(EEnum eObject) {
        return null;
    }

    public Object caseEOperation(EOperation eObject) {
        @NonNull EOperation eObject2 = eObject;
        if (this.converter.isInvariant(eObject2)) {
            EAnnotation redefinesAnnotation;
            Constraint pivotElement = this.converter.getCreated(Constraint.class, (EObject)eObject2);
            if (pivotElement != null && (redefinesAnnotation = eObject2.getEAnnotation("redefines")) != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    NamedElement redefinedConstraint;
                    if (eReference == null || !this.checkProxy(eReference) || !((redefinedConstraint = this.converter.getCreated(NamedElement.class, eReference)) instanceof Constraint)) continue;
                    pivotElement.getRedefinedConstraints().add((Constraint)redefinedConstraint);
                }
            }
            return pivotElement;
        }
        Operation pivotElement = (Operation)this.caseETypedElement((ETypedElement)eObject2);
        if (pivotElement != null) {
            EAnnotation redefinesAnnotation = eObject2.getEAnnotation("redefines");
            if (redefinesAnnotation != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    NamedElement redefinedOperation;
                    if (eReference == null || !this.checkProxy(eReference) || !((redefinedOperation = this.converter.getCreated(NamedElement.class, eReference)) instanceof Operation)) continue;
                    pivotElement.getRedefinedOperations().add((Operation)redefinedOperation);
                }
            }
            this.doSwitchAll(Type.class, ClassUtil.nullFree(pivotElement.getRaisedExceptions()), (List<? extends EObject>)eObject2.getEGenericExceptions());
        }
        return pivotElement;
    }

    public Object caseEReference(EReference eObject) {
        Property pivotElement = this.caseEStructuralFeature((EStructuralFeature)eObject);
        this.doSwitchAll(Property.class, ClassUtil.nullFree(pivotElement.getKeys()), (List<? extends EObject>)eObject.getEKeys());
        Property oppositeProperty = null;
        EReference eOpposite = eObject.getEOpposite();
        if (eOpposite != null) {
            oppositeProperty = this.converter.getCreated(Property.class, (EObject)eOpposite);
        } else {
            EAnnotation oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
            if (oppositeRole != null) {
                EMap details = oppositeRole.getDetails();
                String oppositeName = (String)details.get((Object)PROPERTY_OPPOSITE_ROLE_NAME_KEY);
                if (oppositeName != null) {
                    UnlimitedNaturalValue upper;
                    IntegerValue lower;
                    oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                    oppositeProperty.setName(oppositeName);
                    oppositeProperty.setIsImplicit(true);
                    Class remoteType = (Class)pivotElement.getType();
                    Class localType = pivotElement.getOwningClass();
                    oppositeProperty.setType(localType);
                    String uniqueValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY);
                    String orderedValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_ORDERED_KEY);
                    String lowerValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_LOWER_KEY);
                    String upperValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UPPER_KEY);
                    boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                    boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                    IntegerValue one = ValueUtil.ONE_VALUE;
                    IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf(lowerValue) : one;
                    if (lower.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                        lower = one;
                    }
                    UnlimitedNaturalValue unlimitedOne = ValueUtil.UNLIMITED_ONE_VALUE;
                    UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf(upperValue) : unlimitedOne;
                    if (upper.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                        upper = unlimitedOne;
                    }
                    if (localType == null) {
                        localType = this.metamodelManager.getStandardLibrary().getOclInvalidType();
                    }
                    if (upper != one) {
                        oppositeProperty.setType(this.metamodelManager.getCollectionType(isOrdered, isUnique, localType, false, lower, upper));
                        oppositeProperty.setIsRequired(true);
                    } else {
                        oppositeProperty.setType(localType);
                        oppositeProperty.setIsRequired(lower == one);
                    }
                    remoteType.getOwnedProperties().add(oppositeProperty);
                    oppositeProperty.setOpposite(pivotElement);
                }
            } else {
                EObject eContainer;
                EMap details;
                String oppositeName;
                oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
                if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null && (eContainer = pivotElement.eContainer()) instanceof Type) {
                    Type localType = (Type)eContainer;
                    Class remoteType = (Class)pivotElement.getType();
                    while (remoteType instanceof CollectionType) {
                        remoteType = (Class)((CollectionType)remoteType).getElementType();
                    }
                    if (remoteType != null) {
                        String upperValue;
                        UnlimitedNaturalValue upper;
                        IntegerValue lower;
                        oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                        oppositeProperty.setName(oppositeName);
                        oppositeProperty.setIsImplicit(true);
                        Model thisModel = PivotUtil.getContainingModel(localType);
                        assert (thisModel != null);
                        Class thisRemoteType = this.metamodelManager.getEquivalentClass(thisModel, remoteType);
                        String lowerValue = (String)details.get((Object)"lower");
                        IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf(lowerValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                        if (lower.isInvalid()) {
                            logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                            lower = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                        }
                        UnlimitedNaturalValue unlimitedNaturalValue = upper = (upperValue = (String)details.get((Object)"upper")) != null ? ValueUtil.unlimitedNaturalValueOf(upperValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                        if (upper.isInvalid()) {
                            logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                            upper = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                        }
                        if (!upper.equals(ValueUtil.ONE_VALUE)) {
                            String uniqueValue = (String)details.get((Object)"unique");
                            boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                            String orderedValue = (String)details.get((Object)"ordered");
                            boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                            oppositeProperty.setType(this.metamodelManager.getCollectionType(isOrdered, isUnique, localType, false, lower, upper));
                            oppositeProperty.setIsRequired(true);
                        } else {
                            oppositeProperty.setType(localType);
                            oppositeProperty.setIsRequired(lower.equals(ValueUtil.ONE_VALUE));
                        }
                        thisRemoteType.getOwnedProperties().add(oppositeProperty);
                        oppositeProperty.setOpposite(pivotElement);
                    }
                }
            }
        }
        if (oppositeProperty != null) {
            pivotElement.setOpposite(oppositeProperty);
        }
        return null;
    }

    public Property caseEStructuralFeature(EStructuralFeature eObject) {
        @NonNull EStructuralFeature eObject2 = eObject;
        Property pivotElement = (Property)this.caseETypedElement((ETypedElement)eObject2);
        if (pivotElement != null) {
            EAnnotation eAnnotation;
            EAnnotation duplicatesAnnotation;
            EObject eContainer;
            EAnnotation redefinesAnnotation = eObject2.getEAnnotation("redefines");
            if (redefinesAnnotation != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    if (eReference == null || !this.checkProxy(eReference)) continue;
                    Property redefinedProperty = this.converter.getCreated(Property.class, eReference);
                    pivotElement.getRedefinedProperties().add(redefinedProperty);
                }
            }
            if ((eContainer = eObject2.eContainer()) instanceof EAnnotation && "duplicates".equals((duplicatesAnnotation = (EAnnotation)eContainer).getSource()) && (eAnnotation = duplicatesAnnotation.getEAnnotation(eObject.getName())) != null) {
                String newLowerBound = null;
                Boolean newOrdered = null;
                Boolean newUnique = null;
                String newUpperBound = null;
                Type newType = null;
                boolean changedType = false;
                EMap details = eAnnotation.getDetails();
                for (String key : details.keySet()) {
                    EClassifier eClassifier;
                    EPackage ePackage;
                    Object value = details.get((Object)key);
                    if (value == null) continue;
                    if ("lowerBound".equals(key)) {
                        newLowerBound = value.toString();
                        changedType = true;
                        continue;
                    }
                    if ("ordered".equals(key)) {
                        newOrdered = Boolean.valueOf(value.toString());
                        changedType = true;
                        continue;
                    }
                    if ("unique".equals(key)) {
                        newUnique = Boolean.valueOf(value.toString());
                        changedType = true;
                        continue;
                    }
                    if ("upperBound".equals(key)) {
                        newUpperBound = value.toString();
                        changedType = true;
                        continue;
                    }
                    if (!"eType".equals(key)) continue;
                    String[] path = value.toString().split("::");
                    EObject eRoot = EcoreUtil.getRootContainer((EObject)eObject);
                    int iSize = path.length;
                    if (iSize < 2 || !(eRoot instanceof EPackage) || !path[0].equals((ePackage = (EPackage)eRoot).getName())) continue;
                    int i = 1;
                    while (ePackage != null && i < iSize - 1) {
                        ePackage = (EPackage)NameUtil.getENamedElement(ePackage.getESubpackages(), path[i]);
                        ++i;
                    }
                    if (ePackage == null || (eClassifier = (EClassifier)NameUtil.getENamedElement(ePackage.getEClassifiers(), path[iSize - 1])) == null) continue;
                    newType = this.converter.getASType((EObject)eClassifier);
                    changedType = true;
                }
                if (changedType) {
                    boolean isRequired;
                    Type pivotType;
                    Type type;
                    UnlimitedNaturalValue oldUpperValue;
                    boolean oldUnique;
                    boolean oldOrdered;
                    IntegerValue oldLowerValue;
                    Type oldType = pivotElement.getType();
                    if (oldType instanceof CollectionType) {
                        CollectionType oldCollectionType = (CollectionType)oldType;
                        oldType = oldCollectionType.getElementType();
                        oldLowerValue = oldCollectionType.getLowerValue();
                        oldOrdered = oldCollectionType.isOrdered();
                        oldUnique = oldCollectionType.isUnique();
                        oldUpperValue = oldCollectionType.getUpperValue();
                    } else {
                        oldLowerValue = pivotElement.isIsRequired() ? ValueUtil.ONE_VALUE : ValueUtil.ZERO_VALUE;
                        oldOrdered = false;
                        oldUnique = false;
                        oldUpperValue = ValueUtil.UNLIMITED_ONE_VALUE;
                    }
                    boolean isOrdered = newOrdered != null ? newOrdered : oldOrdered;
                    IntegerValue lowerValue = newLowerBound != null ? ValueUtil.integerValueOf(newLowerBound) : oldLowerValue;
                    boolean isUnique = newUnique != null ? newUnique : oldUnique;
                    UnlimitedNaturalValue upperValue = newUpperBound != null ? ValueUtil.unlimitedNaturalValueOf(newUpperBound) : oldUpperValue;
                    Type type2 = type = newType != null ? newType : oldType;
                    if (type != null) {
                        pivotType = type;
                        if (upperValue.equals(ValueUtil.ONE_VALUE)) {
                            isRequired = lowerValue.equals(ValueUtil.ONE_VALUE);
                        } else {
                            isRequired = true;
                            pivotType = this.metamodelManager.getCollectionType(isOrdered, isUnique, pivotType, false, lowerValue, upperValue);
                        }
                    } else {
                        isRequired = false;
                        pivotType = this.standardLibrary.getOclVoidType();
                    }
                    pivotElement.setType(pivotType);
                    pivotElement.setIsRequired(isRequired);
                }
            }
            String defaultValueLiteral = null;
            if (eObject.eIsSet((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL)) {
                defaultValueLiteral = eObject.getDefaultValueLiteral();
            }
            pivotElement.setDefaultValueString(defaultValueLiteral);
        }
        return pivotElement;
    }

    public TypedElement caseETypedElement(ETypedElement eObject) {
        @NonNull ETypedElement eObject2 = eObject;
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)eObject2);
        if (pivotElement != null) {
            boolean isRequired;
            Type pivotType;
            EGenericType eType = eObject2.getEGenericType();
            if (eType != null) {
                pivotType = this.converter.getASType((EObject)eType);
                int lower = eObject.getLowerBound();
                int upper = eObject.getUpperBound();
                if (upper == 1) {
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    boolean isNullFree = Ecore2AS.isNullFree(eObject);
                    boolean isOrdered = eObject.isOrdered();
                    boolean isUnique = eObject.isUnique();
                    if (pivotType != null) {
                        IntegerValue lowerValue = ValueUtil.integerValueOf(lower);
                        UnlimitedNaturalValue upperValue = upper != -1 ? ValueUtil.unlimitedNaturalValueOf(upper) : ValueUtil.UNLIMITED_VALUE;
                        pivotType = this.metamodelManager.getCollectionType(isOrdered, isUnique, pivotType, isNullFree, lowerValue, upperValue);
                    }
                }
            } else {
                isRequired = false;
                pivotType = this.standardLibrary.getOclVoidType();
            }
            pivotElement.setType(pivotType);
            pivotElement.setIsRequired(isRequired);
        }
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eObject) {
        @NonNull ETypeParameter eObject2 = eObject;
        TemplateParameter pivotElement = this.converter.getCreated(TemplateParameter.class, (EObject)eObject2);
        if (pivotElement != null) {
            this.doSwitchAll(Class.class, ClassUtil.nullFree(pivotElement.getConstrainingClasses()), (List<? extends EObject>)eObject2.getEBounds());
        }
        return null;
    }

    protected boolean checkProxy(@NonNull EObject eReference) {
        if (!eReference.eIsProxy()) {
            return true;
        }
        this.converter.error("Unresolved proxy: " + EcoreUtil.getURI((EObject)eReference));
        return false;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        java.lang.Class<T> pivotClass2 = pivotClass;
        for (EObject eObject : eObjects) {
            T pivotElement;
            if (eObject == null || !this.checkProxy(eObject) || (pivotElement = this.converter.getASElement(pivotClass2, eObject)) == null) continue;
            pivotElements.add(pivotElement);
        }
    }
}

