/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class EObjectOperation
extends AbstractOperation {
    protected final @NonNull Operation operation;
    protected final @NonNull EOperation eFeature;
    protected final @NonNull ExpressionInOCL specification;

    public EObjectOperation(@NonNull Operation operation, @NonNull EOperation eFeature, @NonNull ExpressionInOCL specification) {
        this.operation = operation;
        this.eFeature = eFeature;
        this.specification = specification;
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        if (this.specification.getOwnedBody() == null) {
            try {
                MetamodelManager metamodelManager = executor.getMetamodelManager();
                metamodelManager.parseSpecification(this.specification);
            }
            catch (ParserException e) {
                throw new InvalidValueException(e, "parse failure", executor.getEvaluationEnvironment(), sourceValue, callExp);
            }
        }
        ExpressionInOCL query = this.specification;
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        Object[] argumentValues = new Object[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = executor.evaluate(argument);
            ++i;
        }
        EvaluationEnvironment nestedEvaluationEnvironment = executor.pushEvaluationEnvironment(query, callExp);
        nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(query.getOwnedContext()), sourceValue);
        List<Variable> parameterVariables = query.getOwnedParameters();
        int iMax = Math.min(parameterVariables.size(), argumentValues.length);
        int i2 = 0;
        while (i2 < iMax) {
            nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(parameterVariables.get(i2)), argumentValues[i2]);
            ++i2;
        }
        try {
            Object object = executor.evaluate(ClassUtil.nonNullPivot(query.getOwnedBody()));
            return object;
        }
        finally {
            executor.popEvaluationEnvironment();
        }
    }
}

