/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ocl.lpg.FormattingHelper;

public class TypeProposalComputer
implements ProposalComputer {
    private final char[] possibleTypeNameChars = new char[]{':', '{', '}', '(', ')'};
    private final ProposalFactory proposalFactory;

    public TypeProposalComputer(ProposalFactory factory) {
        Arrays.sort(this.possibleTypeNameChars);
        assert (factory != null);
        this.proposalFactory = factory;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext ctx) {
        String prefix = this.findPrefix(txt);
        String[] prefixParts = prefix.split("::", -1);
        LinkedList<EPackage> possiblePackages = new LinkedList<EPackage>();
        if (prefixParts.length > 1) {
            ArrayList<String> p = new ArrayList<String>(5);
            p.addAll(Arrays.asList(prefixParts));
            p.remove(p.size() - 1);
            EPackage r = ctx.getOCLEnvironment().lookupPackage(p);
            if (r != null) {
                possiblePackages.add(r);
            }
        } else {
            for (Object next : ((ExecutionContextImpl)ctx).getAllVisibleModels().values()) {
                if (!(next instanceof EPackage)) continue;
                possiblePackages.add((EPackage)next);
            }
        }
        String typeNamePrefix = prefixParts.length == 0 ? "" : prefixParts[prefixParts.length - 1];
        LinkedList<ICompletionProposal> result = new LinkedList<ICompletionProposal>();
        FormattingHelper formatter = ctx.getOCLEnvironment().getFormatter();
        EPackage oclStdLibPackage = ((EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getOclAny()).getEPackage();
        for (EPackage pkg : possiblePackages) {
            for (EClassifier type : pkg.getEClassifiers()) {
                String displayStr;
                if (type.getName() == null || !type.getName().startsWith(typeNamePrefix)) continue;
                String insertString = formatter.formatQualifiedName((Object)type);
                if (!insertString.startsWith(prefix) && insertString.indexOf(prefix) > 0) {
                    insertString = insertString.substring(insertString.indexOf(prefix));
                }
                if (pkg != oclStdLibPackage) {
                    String packName = formatter.formatQualifiedName((Object)type.getEPackage());
                    displayStr = String.valueOf(type.getName()) + " - " + packName;
                } else {
                    displayStr = type.getName();
                }
                result.add(this.proposalFactory.createTypeProposal(insertString, displayStr.toString(), prefix));
            }
            String pkgQualifiedName = formatter.formatQualifiedName((Object)pkg);
            if (!pkgQualifiedName.startsWith(prefix)) continue;
            result.add(this.proposalFactory.createTypeProposal(String.valueOf(pkgQualifiedName) + "::", pkgQualifiedName, prefix));
        }
        return result;
    }

    public String findPrefix(String txt) {
        StringBuilder result = new StringBuilder();
        int i = txt.length() - 1;
        char c = txt.charAt(i);
        while (Character.isJavaIdentifierPart(c) || Arrays.binarySearch(this.possibleTypeNameChars, c) >= 0) {
            result.append(c);
            if (i <= 0) break;
            c = txt.charAt(--i);
        }
        return result.reverse().toString();
    }
}

