/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.ui.services;

import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoResourceException;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XtextErrorUtil;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RuntimeErrorService {
    private static String PROBLEMS_VIEW = "org.eclipse.ui.views.ProblemView";
    private static final Logger logger = Logger.getLogger(RuntimeErrorService.class);
    private static RuntimeErrorService runtimeErrorRunner;
    private OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
    private XtextErrorUtil xTextErrorUtil = XtextErrorUtil.getInstance();

    public static RuntimeErrorService getInstance() {
        if (runtimeErrorRunner == null) {
            runtimeErrorRunner = new RuntimeErrorService();
        }
        return runtimeErrorRunner;
    }

    public boolean showSMVRuntimeErrors(Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Show Runtime Errors", 1);
        File smvFile = this.ocraDialogUtil.getSmvFileFromFileDialog();
        boolean isValid = this.showSMVRuntimeErrors(resource, smvFile, usexTextValidation, showNoErrorPopup, monitor);
        monitor.done();
        return isValid;
    }

    public boolean showSMVRuntimeErrors(Resource resource, File smvFile, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        if (resource != null && smvFile != null && smvFile.exists()) {
            monitor.subTask("show Runtime Errors");
            boolean isValid = this.xTextErrorUtil.xTextValidationSMV(smvFile, resource, usexTextValidation, showNoErrorPopup, monitor);
            this.openProblemsView();
            return isValid;
        }
        throw new NoResourceException();
    }

    public boolean showOSSRuntimeErrors(Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Show Runtime Errors", 1);
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        boolean isValid = this.showOSSRuntimeErrors(ossFile, resource, usexTextValidation, showNoErrorPopup, monitor);
        monitor.done();
        return isValid;
    }

    public boolean showOSSRuntimeErrors(File ossFile, Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        if (resource != null && ossFile != null && ossFile.exists()) {
            monitor.subTask("show Runtime Errors");
            boolean isValid = this.xTextErrorUtil.xTextValidationOSS(ossFile, resource, usexTextValidation, showNoErrorPopup, monitor);
            this.openProblemsView();
            return isValid;
        }
        throw new NoResourceException();
    }

    public void openProblemsView() {
        Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(PROBLEMS_VIEW);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

