/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.core.utils;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.tools.editor.basetype.ui.internal.BasetypeActivator;
import eu.fbk.tools.editor.c.statement.ui.internal.StatementActivator;
import eu.fbk.tools.editor.c.ui.internal.CActivator;
import eu.fbk.tools.editor.contract.constraint.Constraint.ui.internal.ConstraintActivator;
import eu.fbk.tools.editor.contract.constraint.ui.ConstraintResourceProvider;
import eu.fbk.tools.editor.contract.expression.ui.ExpressionResourceProvider;
import eu.fbk.tools.editor.contract.expression.ui.internal.ExpressionActivator;
import eu.fbk.tools.editor.contract.ui.internal.ContractActivator;
import eu.fbk.tools.editor.nusmv.ui.internal.NusmvActivator;
import eu.fbk.tools.editor.oss.ui.internal.OssActivator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;

public class XTextResourceUtil {
    private static XTextResourceUtil xTextResourceUtil;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(XTextResourceUtil.class);
    }

    public static XTextResourceUtil getInstance() {
        if (xTextResourceUtil == null) {
            xTextResourceUtil = new XTextResourceUtil();
        }
        return xTextResourceUtil;
    }

    public XtextResource createXTextExpressionResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextExpressionResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createXTextConstraintResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextConstraintResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createXTextCExpressionResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextConstraintResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createOSSResourceFromFile(String path) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getOssInjector().getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        return (XtextResource)resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    public XtextResource createNuXmvResourceFromFile(String path) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getNuSMVInjector().getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        return (XtextResource)resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    public Injector getOssInjector() {
        Injector injector = OssActivator.getInstance().getInjector("eu.fbk.tools.editor.oss.Oss");
        return injector;
    }

    public Injector getContractInjector() {
        Injector injector = ContractActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.Contract");
        return injector;
    }

    public Injector getConstraintInjector() {
        Injector injector = ConstraintActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.constraint.Constraint");
        return injector;
    }

    public Injector getExpressionInjector() {
        Injector injector = ExpressionActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.expression.Expression");
        return injector;
    }

    public Injector getNuSMVInjector() {
        Injector injector = NusmvActivator.getInstance().getInjector("eu.fbk.tools.editor.nusmv.NuSMV");
        return injector;
    }

    public Injector getBaseTypeInjector() {
        Injector injector = BasetypeActivator.getInstance().getInjector("eu.fbk.tools.editor.basetype.BaseType");
        return injector;
    }

    public Injector getCleanCInjector() {
        Injector injector = CActivator.getInstance().getInjector("eu.fbk.tools.editor.c.C");
        return injector;
    }

    public Injector getCleanCStatementInjector() {
        Injector injector = StatementActivator.getInstance().getInjector("eu.fbk.tools.editor.c.statement.Statement");
        return injector;
    }

    public Injector getCleanCExpressionInjector() {
        Injector injector = eu.fbk.tools.editor.c.expression.ui.internal.ExpressionActivator.getInstance().getInjector("eu.fbk.tools.editor.c.expression.Expression");
        return injector;
    }

    public EObject deserializeCleanCExpression(String expression) throws Exception {
        Injector injector = this.getCleanCExpressionInjector();
        ParseHelper exprParseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        return exprParseHelper.parse((CharSequence)expression);
    }

    public XtextResource createXTextConstraintResource() {
        ConstraintResourceProvider serviceProvider = (ConstraintResourceProvider)this.getConstraintInjector().getInstance(ConstraintResourceProvider.class);
        return serviceProvider.createResource();
    }

    public XtextResource createXTextCleanCExpressionResource() {
        ExpressionResourceProvider serviceProvider = (ExpressionResourceProvider)this.getCleanCExpressionInjector().getInstance(ExpressionResourceProvider.class);
        return serviceProvider.createResource();
    }

    public XtextResource createXTextExpressionResource() {
        ExpressionResourceProvider serviceProvider = (ExpressionResourceProvider)this.getExpressionInjector().getInstance(ExpressionResourceProvider.class);
        return serviceProvider.createResource();
    }

    public EObject deserializeCleanCStatement(String statement) throws Exception {
        Injector injector = this.getCleanCStatementInjector();
        ParseHelper exprParseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        return exprParseHelper.parse((CharSequence)statement);
    }
}

