/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.contracts.refinementview.view;

import eu.fbk.contracts.refinementview.treeElements.RootNode;
import eu.fbk.contracts.refinementview.treeProviders.TreeContentProvider;
import eu.fbk.contracts.refinementview.treeProviders.TreeLabelProvider;
import eu.fbk.contracts.refinementview.treeProviders.TreeSorter;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public abstract class RefinementView
extends ViewPart {
    public static String ID_PLUGIN = "eu.fbk.eclipse.standardtools.refinementView.core";
    public static final int COLUMN_ELEMENT = 0;
    public static final int COLUMN_NUMBER = 1;
    private TreeViewer treeviewer;
    private Tree tree;
    private TreeColumn column0;
    private TreeColumn column1;
    private TreeSorter sorter;

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 2);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.treeviewer = new TreeViewer(this.tree);
        this.sorter = new TreeSorter(this.treeviewer);
        this.column0 = new TreeColumn(this.tree, 0);
        this.column0.setText("Refined Contracts");
        this.column0.setWidth(300);
        this.sorter.addColumn(this.column0, 0);
        this.column1 = new TreeColumn(this.tree, 0);
        this.column1.setText("Number of sub-contracts");
        this.column1.setWidth(300);
        this.sorter.setSortColumnAndDirection(this.column0, this.sorter.isReverseSort() ? 1024 : 128);
        this.treeviewer.setComparator((ViewerComparator)this.sorter);
        this.treeviewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.updateView();
    }

    public void setTreeViewerInput(RootNode rootNode) {
        if (!this.treeviewer.isBusy()) {
            this.treeviewer.setInput((Object)rootNode);
        }
    }

    public void setFocus() {
        this.updateView();
    }

    public void refreshViewer() {
        this.treeviewer.refresh();
    }

    public void updateView() {
        if (!this.treeviewer.isBusy()) {
            ArrayList<Object> allContracts = new ArrayList<Object>();
            ArrayList<String> componentInstances = new ArrayList<String>();
            ArrayList<String> contractsUsedForRefinement = new ArrayList<String>();
            RootNode rootNode = this.getModelObjects(allContracts, componentInstances, contractsUsedForRefinement);
            if (rootNode != null) {
                this.setTreeViewerInput(rootNode);
            } else {
                this.treeviewer.setInput(null);
            }
        }
    }

    public abstract RootNode getModelObjects(ArrayList<Object> var1, ArrayList<String> var2, ArrayList<String> var3);
}

