/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.modelTranslators;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.EmptyEnumTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.NullTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.UnexpectedTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoComponentException;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.basetype.baseType.BaseTypeFactory;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.FixedSizeArrayType;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.contract.constraint.constraint.PortConstraint;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Contracts;
import eu.fbk.tools.editor.contract.expression.expression.ArrayIndex;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.ExpressionFactory;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.Interface;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OssFactory;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterAssumptions;
import eu.fbk.tools.editor.oss.oss.ParameterizedArrayType;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SubComponentType;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.TimeAnnotation;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class GenericModelToOSSModelTranslator {
    private static final Logger logger = Logger.getLogger(GenericModelToOSSModelTranslator.class);
    private final String language = "OCRA";
    private final OssFactory ossFactory = OssFactory.eINSTANCE;
    private final ExpressionFactory expressionFactory = ExpressionFactory.eINSTANCE;
    private final BaseTypeFactory baseTypeFactory = BaseTypeFactory.eINSTANCE;
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    private final OSSModelFactory ossModelFactory = OSSModelFactory.getInstance();
    private AbstractSystemModel abstractSystemModel;
    private static GenericModelToOSSModelTranslator toolToOCRAModelTranslatorAbstr;

    public static GenericModelToOSSModelTranslator getInstance(AbstractSystemModel abstractSystemModel) {
        if (toolToOCRAModelTranslatorAbstr == null) {
            toolToOCRAModelTranslatorAbstr = new GenericModelToOSSModelTranslator(abstractSystemModel);
        }
        return toolToOCRAModelTranslatorAbstr;
    }

    private GenericModelToOSSModelTranslator(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
    }

    private OSS compileOssFileFromRootComponent(Object component, List<?> contracts, boolean isDiscreteTime) throws Exception {
        OSS ocraOssFile = this.ossModelFactory.createOssResource();
        if (isDiscreteTime) {
            TimeAnnotation ocraTimeAnnotation = this.ossFactory.createTimeAnnotation();
            ocraTimeAnnotation.setValue("discrete-time");
            ocraOssFile.setAnnotation(ocraTimeAnnotation);
        }
        SystemComponent ocraSystem = this.ossFactory.createSystemComponent();
        ocraOssFile.setSystem(ocraSystem);
        ocraSystem.setType(this.abstractSystemModel.getComponentTypeName(component));
        Interface ocraInterface_ = this.ossFactory.createInterface();
        ocraSystem.setInterface(ocraInterface_);
        this.compileComponent(component, contracts, ocraInterface_);
        Refinement ocraRefinement = OssFactory.eINSTANCE.createRefinement();
        this.compileSubcomponents(component, ocraRefinement);
        this.compileConnections(component, ocraRefinement);
        this.compilePortsConstraints(component, ocraRefinement);
        this.compileContractRefinements(component, ocraRefinement);
        this.compileRefinementAssertions(component, ocraRefinement);
        if (!ocraRefinement.getRefinements().isEmpty()) {
            ocraSystem.setRefinement(ocraRefinement);
        }
        ArrayList<Component> ocraChildComponents = new ArrayList<Component>();
        this.compileSubComponent(component, contracts, ocraChildComponents);
        ocraOssFile.getComponents().addAll(ocraChildComponents);
        return ocraOssFile;
    }

    private void compileRefinementAssertions(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList refinementAssertions = this.abstractSystemModel.getRefinementAssertions(component);
        if (refinementAssertions != null) {
            for (Object refinementAssertion : refinementAssertions) {
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                Assertion ocraRefinementAssertion = this.ossFactory.createAssertion();
                this.compileRefinementAssertionExpression(ocraRefinementAssertion, refinementAssertion);
                ocraRefInstance.setAssertion(ocraRefinementAssertion);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    public OSS exportRootComponentAsOssModel(Object rootComponent, boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Export system model as Oss Model", 1);
        logger.debug((Object)"beginTask: Export system model as Oss Model ");
        if (rootComponent == null) {
            throw new NoComponentException();
        }
        logger.debug((Object)"getContractsOfComponent");
        EList contracts = this.abstractSystemModel.getContractsOfComponent(rootComponent);
        logger.debug((Object)"compileOssFileFromRootComponent");
        OSS ocraModel = this.compileOssFileFromRootComponent(rootComponent, (List<?>)contracts, isDiscreteTime);
        logger.debug((Object)"compileOssFileFromRootComponent done");
        monitor.done();
        logger.debug((Object)"done: Export system model as Oss Model ");
        return ocraModel;
    }

    public String getFileName(Object component) {
        return this.abstractSystemModel.getComponentName(component);
    }

    private void compileOutputports(List<InterfaceInstance> ocraPorts, EList<?> outputPorts, String componentName) throws Exception {
        for (Object outputPort : outputPorts) {
            OutputPort ocraOutputPort = this.ossFactory.createOutputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraOutputPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(outputPort);
            PortId varId = this.expressionFactory.createPortId();
            varId.setName(portName);
            ocraOutputPort.setId((VariableId)varId);
            this.compilePortType(outputPort, componentName, portName, (Port)ocraOutputPort);
        }
    }

    private FullPortId createFullPortId(String portNameStr) {
        FullPortId ocraPortId = this.expressionFactory.createFullPortId();
        PortId varId = this.expressionFactory.createPortId();
        varId.setName(portNameStr);
        ocraPortId.setId((VariableId)varId);
        return ocraPortId;
    }

    private void compileInterfaceAssertions(List<InterfaceInstance> ocraInterfaceAssertions, EList<?> interfaceAssertions) throws Exception {
        for (Object interfaceAssertion : interfaceAssertions) {
            Assertion ocraInterfaceAssertion = this.ossFactory.createAssertion();
            this.compileInterfaceAssertionExpression(ocraInterfaceAssertion, interfaceAssertion);
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setAssertion(ocraInterfaceAssertion);
            ocraInterfaceAssertions.add(interfaceInstance);
        }
    }

    private void compileInterfaceAssertionExpression(Assertion ocraInterfaceAssertion, Object interfaceAssertion) throws Exception {
        String intAssertionName = this.abstractSystemModel.getInterfaceAssertionName(interfaceAssertion);
        ocraInterfaceAssertion.setName(intAssertionName);
        String assertionBody = this.abstractSystemModel.getInterfaceAssertionBody(interfaceAssertion, "OCRA");
        ocraInterfaceAssertion.setConstraint(this.stringToOcraExpression(assertionBody));
    }

    private void compileRefinementAssertionExpression(Assertion ocraRefinementAssertion, Object refinementAssertion) throws Exception {
        String refAssertionName = this.abstractSystemModel.getRefinementAssertionName(refinementAssertion);
        ocraRefinementAssertion.setName(refAssertionName);
        ocraRefinementAssertion.setConstraint(this.stringToOcraExpression(this.abstractSystemModel.getRefinementAssertionBody(refinementAssertion, "OCRA")));
    }

    private void compileInputPorts(List<InterfaceInstance> ocraPorts, EList<?> inputPorts, String componentName) throws Exception {
        for (Object inputPort : inputPorts) {
            InputPort ocraInputPort = this.ossFactory.createInputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraInputPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(inputPort);
            PortId portId = this.expressionFactory.createPortId();
            portId.setName(portName);
            ocraInputPort.setId((VariableId)portId);
            this.compilePortType(inputPort, componentName, portName, (Port)ocraInputPort);
        }
    }

    private void compileGenericPorts(List<InterfaceInstance> ocraPorts, EList<?> genericPorts, String componentName) throws Exception {
        logger.debug((Object)"For the moment, generic ports (with inout type) are converted in input ports");
        for (Object genericPort : genericPorts) {
            InputPort ocraGenericPort = this.ossFactory.createInputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraGenericPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(genericPort);
            PortId varId = this.expressionFactory.createPortId();
            varId.setName(portName);
            ocraGenericPort.setId((VariableId)varId);
            this.compilePortType(genericPort, componentName, portName, (Port)ocraGenericPort);
        }
    }

    private void compileStaticPorts(List<InterfaceInstance> ocraParameters, EList<?> staticPorts, String componentName) throws Exception {
        for (Object staticPort : staticPorts) {
            Parameter ocraParameter = this.ossFactory.createParameter();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraParameter);
            ocraParameters.add(interfaceInstance);
            String staticPortName = this.abstractSystemModel.getPortName(staticPort);
            ParameterId varId = this.expressionFactory.createParameterId();
            varId.setName(staticPortName);
            ocraParameter.setId((VariableId)varId);
            this.compileStaticPortType(staticPort, componentName, staticPortName, ocraParameter);
        }
    }

    private void compileDefines(List<InterfaceInstance> ocraDefines, EList<?> defines) throws Exception {
        for (Object define : defines) {
            Define ocraDefine = this.ossFactory.createDefine();
            this.compileDefineExpression(ocraDefine, define);
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setDefine(ocraDefine);
            ocraDefines.add(interfaceInstance);
        }
    }

    private void compileDefineExpression(Define ocraDefine, Object define) throws Exception {
        String defineName = this.abstractSystemModel.getInterfaceAssertionName(define);
        ocraDefine.setName(defineName);
        String defineBody = this.abstractSystemModel.getInterfaceAssertionBody(define, "OCRA");
        ocraDefine.setConstraint(this.stringToOcraExpression(defineBody));
    }

    private void compileUninterpretedFunctions(List<InterfaceInstance> ocraParameters, EList<?> uninterpretedFunctions, String componentName) throws Exception {
        for (Object uninterpretedFunction : uninterpretedFunctions) {
            Parameter ocraParameter = this.ossFactory.createParameter();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraParameter);
            ocraParameters.add(interfaceInstance);
            Object outputType = this.abstractSystemModel.getUninterpretedFunctionOutputType(uninterpretedFunction);
            EList inputTypes = this.abstractSystemModel.getUninterpretedFunctionInputTypes(uninterpretedFunction);
            String[] outputMultiplicity = this.abstractSystemModel.getUninterpretedFunctionOutputMultiplicity(uninterpretedFunction);
            EList inputMultiplicities = this.abstractSystemModel.getUninterpretedFunctionInputMultiplicities(uninterpretedFunction);
            String uninterpretedFunctionName = this.abstractSystemModel.getUninterpretedFunctionName(uninterpretedFunction);
            ParameterId varId = this.expressionFactory.createParameterId();
            varId.setName(uninterpretedFunctionName);
            ocraParameter.setId((VariableId)varId);
            this.compileUninterpretedFunctionType(outputType, outputMultiplicity, componentName, uninterpretedFunctionName, ocraParameter);
            this.compileUninterpretedFunctionParameters(inputTypes, (EList<String[]>)inputMultiplicities, componentName, uninterpretedFunctionName, ocraParameter);
        }
    }

    private void compileComponent(Object component, List<?> contracts, Interface ocraInterface_) throws Exception {
        EList parameters;
        EList outputPorts;
        EList genericPorts;
        String componentName = this.abstractSystemModel.getComponentName(component);
        ArrayList<InterfaceInstance> ocraPorts = new ArrayList<InterfaceInstance>();
        EList inputPorts = this.abstractSystemModel.getNonStaticInputPorts(component);
        if (inputPorts != null && inputPorts.size() != 0) {
            this.compileInputPorts(ocraPorts, inputPorts, componentName);
        }
        if ((genericPorts = this.abstractSystemModel.getNonStaticGenericPorts(component)) != null && genericPorts.size() != 0) {
            this.compileGenericPorts(ocraPorts, genericPorts, componentName);
        }
        if ((outputPorts = this.abstractSystemModel.getNonStaticOutputPorts(component)) != null && outputPorts.size() != 0) {
            this.compileOutputports(ocraPorts, outputPorts, componentName);
        }
        if ((parameters = this.abstractSystemModel.getStaticPorts(component)) != null && parameters.size() != 0) {
            this.compileStaticPorts(ocraPorts, parameters, componentName);
        }
        ocraInterface_.getInterfaces().addAll(ocraPorts);
        ArrayList<InterfaceInstance> ocraDefines = new ArrayList<InterfaceInstance>();
        EList defines = this.abstractSystemModel.getDefines(component);
        if (defines != null && defines.size() != 0) {
            this.compileDefines(ocraDefines, defines);
        }
        ocraInterface_.getInterfaces().addAll(ocraDefines);
        ArrayList<InterfaceInstance> ocraParameters = new ArrayList<InterfaceInstance>();
        EList uninterpretedFunctions = this.abstractSystemModel.getUninterpretedFunctions(component);
        if (uninterpretedFunctions != null && uninterpretedFunctions.size() != 0) {
            this.compileUninterpretedFunctions(ocraParameters, uninterpretedFunctions, componentName);
        }
        ocraInterface_.getInterfaces().addAll(ocraParameters);
        ArrayList<InterfaceInstance> ocraInterfaceAssertions = new ArrayList<InterfaceInstance>();
        EList interfaceAssertions = this.abstractSystemModel.getInterfaceAssertions(component);
        if (interfaceAssertions != null && interfaceAssertions.size() != 0) {
            this.compileInterfaceAssertions(ocraInterfaceAssertions, interfaceAssertions);
        }
        ocraInterface_.getInterfaces().addAll(ocraInterfaceAssertions);
        this.compileParameterAssumptions(component, ocraInterface_);
        if (contracts != null && !contracts.isEmpty()) {
            ArrayList<InterfaceInstance> ocraContractsToAdd = new ArrayList<InterfaceInstance>();
            ArrayList<Contract> ossContracts = new ArrayList<Contract>(this.getOSSContractDefinitions(component));
            if (ossContracts != null && !ossContracts.isEmpty()) {
                int i = 0;
                while (i < ossContracts.size()) {
                    Contract ocraContract = (Contract)ossContracts.get(i);
                    InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
                    interfaceInstance.setContract(ocraContract);
                    ocraContractsToAdd.add(interfaceInstance);
                    ++i;
                }
                ocraInterface_.getInterfaces().addAll(ocraContractsToAdd);
            }
        }
    }

    private void compileParameterAssumptions(Object component, Interface ocraInterface) throws Exception {
        ArrayList<InterfaceInstance> ocraInterfaceInstances = new ArrayList<InterfaceInstance>();
        EList parameterAssumptions = this.abstractSystemModel.getParameterAssumptions(component);
        if (parameterAssumptions != null) {
            for (Object parameterAssumption : parameterAssumptions) {
                InterfaceInstance ocraIterfaceInstance = this.ossFactory.createInterfaceInstance();
                ParameterAssumptions ocraParameterAssumptions = this.ossFactory.createParameterAssumptions();
                this.compileParameterAssumptionsExpression(ocraParameterAssumptions, parameterAssumption);
                ocraIterfaceInstance.setParameterAssumptions(ocraParameterAssumptions);
                ocraInterfaceInstances.add(ocraIterfaceInstance);
            }
        }
        ocraInterface.getInterfaces().addAll(ocraInterfaceInstances);
    }

    private void compileParameterAssumptionsExpression(ParameterAssumptions ocraParameterAssumptions, Object parameterAssumption) throws Exception {
        String parameterAssumptionsText = this.abstractSystemModel.getParameterAssumptionsBody(parameterAssumption, "OCRA");
        logger.debug((Object)("getParameterAssumptionsBody: " + parameterAssumptionsText));
        ocraParameterAssumptions.setConstraint(this.stringToOcraExpression(parameterAssumptionsText));
    }

    private List<String> getOSSContractsNames(Object component) throws Exception {
        List<Contract> ossContracts = this.getOSSContractDefinitions(component);
        ArrayList<String> ossContractsNames = null;
        if (ossContracts != null && !ossContracts.isEmpty()) {
            ossContractsNames = new ArrayList<String>();
            for (Contract ossContract : ossContracts) {
                ossContractsNames.add(ossContract.getName());
            }
        }
        return ossContractsNames;
    }

    private List<Contract> getOSSContractDefinitions(Object component) throws Exception {
        String contractsInStr = this.abstractSystemModel.getContractDefinitionsText(component);
        return this.stringToOSSContracts(contractsInStr);
    }

    private EList<Contract> stringToOSSContracts(String contractDefinitions) throws Exception {
        if (contractDefinitions == null || contractDefinitions.isEmpty()) {
            return null;
        }
        Injector injector = this.xtextResourceUtil.getContractInjector();
        ParseHelper parseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        Contracts result = (Contracts)parseHelper.parse((CharSequence)contractDefinitions);
        return result.getContracts();
    }

    private PortConstraint stringToOcraConstraint(String constraint) throws Exception {
        if (constraint == null || constraint.isEmpty()) {
            return null;
        }
        Injector injector = this.xtextResourceUtil.getConstraintInjector();
        ParseHelper parseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        PortConstraint result = (PortConstraint)parseHelper.parse((CharSequence)constraint);
        return result;
    }

    private Expression stringToOcraExpression(String ocraInterfaceAssertionText) throws Exception {
        if (ocraInterfaceAssertionText == null || ocraInterfaceAssertionText.isEmpty()) {
            return null;
        }
        Injector injector = this.xtextResourceUtil.getExpressionInjector();
        ParseHelper parseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        Expression result = (Expression)parseHelper.parse((CharSequence)ocraInterfaceAssertionText);
        return result;
    }

    private ArrayList<Object> getAllContractInstancesFromRefinementsOfConstracts(List<?> parentContracts) {
        HashSet<Object> contractInstancesOfAllSubComponentsSet = new HashSet<Object>();
        if (parentContracts != null) {
            for (Object parentContract : parentContracts) {
                for (Object contractRefinement : this.abstractSystemModel.getContractRefinements(parentContract)) {
                    contractInstancesOfAllSubComponentsSet.add(this.abstractSystemModel.getContractInstanceOfContractRefinement(contractRefinement));
                }
            }
        }
        ArrayList<Object> contractInstancesOfAllSubComponentsList = new ArrayList<Object>(contractInstancesOfAllSubComponentsSet);
        return contractInstancesOfAllSubComponentsList;
    }

    private void compileSubComponent(Object parentComponent, List<?> parentContracts, List<Component> ocraChildComponents) throws Exception {
        EList subComponents = this.abstractSystemModel.getSubComponentsInstances(parentComponent);
        if (subComponents.isEmpty()) {
            return;
        }
        ArrayList<Object> contractInstancesOfAllSubComponentsList = this.getAllContractInstancesFromRefinementsOfConstracts(parentContracts);
        for (Object subComponent : subComponents) {
            Component ocraChildComponent = OssFactory.eINSTANCE.createComponent();
            String componentInstanceTypeName = this.abstractSystemModel.getComponentInstanceTypeName(subComponent);
            if (!this.isValidName(componentInstanceTypeName)) {
                throw new Exception("The component's name '" + componentInstanceTypeName + "' contains invalid characters (e.g. '-').");
            }
            ocraChildComponent.setType(componentInstanceTypeName);
            List<Object> contractInstancesOfSubComponent = this.getContractInstancesOfComponent(subComponent, contractInstancesOfAllSubComponentsList);
            Interface ocraInterface_ = this.ossFactory.createInterface();
            ocraChildComponent.setInterface(ocraInterface_);
            this.compileComponent(subComponent, contractInstancesOfSubComponent, ocraInterface_);
            Refinement ocraSubComponentRefinement = OssFactory.eINSTANCE.createRefinement();
            this.compileSubcomponents(subComponent, ocraSubComponentRefinement);
            this.compileConnections(subComponent, ocraSubComponentRefinement);
            this.compilePortsConstraints(subComponent, ocraSubComponentRefinement);
            this.compileContractRefinements(subComponent, ocraSubComponentRefinement);
            if (!ocraSubComponentRefinement.getRefinements().isEmpty()) {
                ocraChildComponent.setRefinement(ocraSubComponentRefinement);
            }
            this.compileRefinementAssertions(subComponent, ocraSubComponentRefinement);
            if (!this.contains(ocraChildComponents, ocraChildComponent)) {
                ocraChildComponents.add(ocraChildComponent);
            }
            this.compileSubComponent(subComponent, contractInstancesOfSubComponent, ocraChildComponents);
        }
    }

    private boolean isValidName(String componentInstanceTypeName) {
        return !componentInstanceTypeName.contains("-");
    }

    private boolean contains(List<Component> components, Component component) {
        for (Component currComponent : components) {
            if (currComponent.getType().compareTo(component.getType()) != 0) continue;
            return true;
        }
        return false;
    }

    private void compilePortType(Object port, String componentName, String portName, Port ocraPort) throws Exception {
        Object type = this.abstractSystemModel.getPortType(port);
        SimpleType simplePortType = this.getTypeOfPort(type, componentName, portName);
        String[] portMultiplicityBoundariesAsExpressions = this.abstractSystemModel.getPortMultiplicityBoundaries(port);
        ocraPort.setType(this.createComplexType(simplePortType, portMultiplicityBoundariesAsExpressions, portName, componentName));
    }

    private ComplexType createComplexType(SimpleType simplePortType, String[] portMultiplicityBoundariesAsExpressions, String elementName, String componentName) throws Exception {
        ComplexType complexType = this.ossFactory.createComplexType();
        if (StringArrayUtil.isUndefined((String[])portMultiplicityBoundariesAsExpressions)) {
            logger.debug((Object)"isMultiplicityUndefined");
            complexType.setComplexType((EObject)simplePortType);
        } else if (StringArrayUtil.isSameValues((String[])portMultiplicityBoundariesAsExpressions)) {
            if (StringArrayUtil.isInteger((String)portMultiplicityBoundariesAsExpressions[1])) {
                FixedSizeArrayType arrayType = this.baseTypeFactory.createFixedSizeArrayType();
                arrayType.setType(simplePortType);
                IntegerLiteral integerLiteralMulitplicity = this.baseTypeFactory.createIntegerLiteral();
                integerLiteralMulitplicity.setValue(String.valueOf(portMultiplicityBoundariesAsExpressions[1]));
                arrayType.setNumber((EObject)integerLiteralMulitplicity);
                complexType.setComplexType((EObject)arrayType);
            } else {
                ParameterizedArrayType arrayType = this.ossFactory.createParameterizedArrayType();
                arrayType.setType(simplePortType);
                Expression expr = this.stringToOcraExpression(portMultiplicityBoundariesAsExpressions[1]);
                arrayType.setNumber(expr);
                complexType.setComplexType((EObject)arrayType);
            }
        } else if (StringArrayUtil.isZeroNumber((String)portMultiplicityBoundariesAsExpressions[0]) && StringArrayUtil.isInteger((String)portMultiplicityBoundariesAsExpressions[1])) {
            FixedSizeArrayType arrayType = this.baseTypeFactory.createFixedSizeArrayType();
            arrayType.setType(simplePortType);
            IntegerLiteral integerLiteralMulitplicity = this.baseTypeFactory.createIntegerLiteral();
            integerLiteralMulitplicity.setValue(String.valueOf(Integer.parseInt(portMultiplicityBoundariesAsExpressions[1]) + 1));
            arrayType.setNumber((EObject)integerLiteralMulitplicity);
            complexType.setComplexType((EObject)arrayType);
        } else {
            throw new Exception("The element \"" + elementName + "\" of the component\"" + componentName + "\" cannot have different upper and lower values defined as expression.");
        }
        return complexType;
    }

    private void compileStaticPortType(Object parameter, String componentName, String portName, Parameter ocraParameter) throws Exception {
        Object type = this.abstractSystemModel.getPortType(parameter);
        String[] portMultiplicityBoundariesAsExpressions = this.abstractSystemModel.getPortMultiplicityBoundaries(parameter);
        SimpleType simplePortType = this.getTypeOfPort(type, componentName, portName);
        ComplexType complexType = this.createComplexType(simplePortType, portMultiplicityBoundariesAsExpressions, portName, componentName);
        ocraParameter.setType(complexType);
    }

    private void compileUninterpretedFunctionType(Object outputType, String[] multiplicity, String componentName, String uninterpretedFunctionName, Parameter ocraParameter) throws Exception {
        SimpleType simpleUninterpretedFunctionType = this.getTypeOfUninterpretedFunction(outputType, componentName, uninterpretedFunctionName);
        ComplexType complexUninterpretedFunctionType = this.createComplexType(simpleUninterpretedFunctionType, multiplicity, uninterpretedFunctionName, componentName);
        ocraParameter.setType(complexUninterpretedFunctionType);
    }

    private void compileUninterpretedFunctionParameters(EList<?> inputTypes, EList<String[]> inputMultiplicities, String componentName, String uninterpretedFunctionName, Parameter ocraParameter) throws Exception {
        if (inputTypes != null && inputTypes.size() > 0) {
            int i = 0;
            while (i < inputTypes.size()) {
                SimpleType simpleType = this.getTypeOfUninterpretedFunction(inputTypes.get(i), componentName, uninterpretedFunctionName);
                ComplexType complexUninterpretedFunctionType = this.createComplexType(simpleType, (String[])inputMultiplicities.get(i), uninterpretedFunctionName, componentName);
                ocraParameter.getParameters().add((Object)complexUninterpretedFunctionType);
                ++i;
            }
        }
    }

    private SimpleType getTypeOfPort(Object type, String componentName, String portName) throws Exception {
        try {
            return this.getSimpleType(type);
        }
        catch (EmptyEnumTypeException emptyEnumTypeException) {
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one input type with an enumerator with zero values.");
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            logger.error((Object)"Unexpected parameter type ");
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one parameter with unexpected type.");
        }
        catch (NullTypeException nullTypeException) {
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one parameter with type == null.");
        }
    }

    private SimpleType getSimpleType(Object type) throws EmptyEnumTypeException, UnexpectedTypeException, NullTypeException {
        if (type == null) {
            throw new NullTypeException();
        }
        if (this.abstractSystemModel.isIntType(type)) {
            return this.baseTypeFactory.createIntegerType();
        }
        if (this.abstractSystemModel.isBooleanType(type)) {
            return this.baseTypeFactory.createBooleanType();
        }
        if (this.abstractSystemModel.isRealType(type)) {
            return this.baseTypeFactory.createRealType();
        }
        if (this.abstractSystemModel.isContinuousType(type)) {
            return this.baseTypeFactory.createContinuousType();
        }
        if (this.abstractSystemModel.isRangeType(type)) {
            RangeType rangeType = this.baseTypeFactory.createRangeType();
            String[] bounds = this.abstractSystemModel.getLowerUpperBoundsForRangeType(type);
            IntegerLiteral lowerBound = this.baseTypeFactory.createIntegerLiteral();
            lowerBound.setValue(bounds[0]);
            IntegerLiteral upperBound = this.baseTypeFactory.createIntegerLiteral();
            upperBound.setValue(bounds[1]);
            rangeType.setLowerBound((EObject)lowerBound);
            rangeType.setUpperBound((EObject)upperBound);
            return rangeType;
        }
        if (this.abstractSystemModel.isEnumType(type)) {
            EnumType enumType = this.baseTypeFactory.createEnumType();
            ArrayList<Identifier> enumValues = new ArrayList<Identifier>();
            String[] stringArray = this.abstractSystemModel.getValuesForEnumeratorType(type);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String enumValue = stringArray[n2];
                Identifier idLiteral = this.baseTypeFactory.createIdentifier();
                idLiteral.setValue(enumValue);
                enumValues.add(idLiteral);
                ++n2;
            }
            if (enumValues.isEmpty()) {
                throw new EmptyEnumTypeException();
            }
            enumType.getValues().addAll(enumValues);
            return enumType;
        }
        if (this.abstractSystemModel.isEventType(type)) {
            EventType eventType = this.baseTypeFactory.createEventType();
            return eventType;
        }
        throw new UnexpectedTypeException();
    }

    private SimpleType getTypeOfUninterpretedFunction(Object type, String componentName, String uninterpretedFunctionName) throws Exception {
        try {
            return this.getSimpleType(type);
        }
        catch (EmptyEnumTypeException emptyEnumTypeException) {
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one input type with an enumerator with zero values.");
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            logger.error((Object)"Unexpected parameter type ");
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one parameter with unexpected type.");
        }
        catch (NullTypeException nullTypeException) {
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one parameter with type == null.");
        }
    }

    private void compileSubcomponents(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList children = this.abstractSystemModel.getSubComponentsInstances(component);
        if (children != null) {
            for (Object childComponentInstance : children) {
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                SubComponent ocraSubComponent = this.createSubComponent(childComponentInstance);
                ocraRefInstance.setSubcomponent(ocraSubComponent);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    private SubComponent createSubComponent(Object childComponentInstance) throws Exception {
        SubComponent ocraSubComponent = this.ossFactory.createSubComponent();
        SubComponentType ocraSubComponentType = this.ossFactory.createSubComponentType();
        String subCompNameStr = this.abstractSystemModel.getComponentInstanceName(childComponentInstance);
        String subCompTypeStr = this.abstractSystemModel.getComponentInstanceTypeName(childComponentInstance);
        String[] componentInstanceMultiplicityBoundaries = this.abstractSystemModel.getComponentInstanceMultiplicityBoundaries(childComponentInstance);
        logger.debug((Object)"createSubComponent");
        logger.debug((Object)("subCompNameStr: " + subCompNameStr));
        logger.debug((Object)("subCompTypeStr: " + subCompTypeStr));
        logger.debug((Object)("componentInstanceMultiplicityBoundaries: " + componentInstanceMultiplicityBoundaries[0] + " " + componentInstanceMultiplicityBoundaries[1]));
        ComponentId fullSubComponentId = this.expressionFactory.createComponentId();
        fullSubComponentId.setName(subCompNameStr);
        ocraSubComponent.setName(fullSubComponentId);
        ocraSubComponent.setType(ocraSubComponentType);
        if (StringArrayUtil.isUndefined((String[])componentInstanceMultiplicityBoundaries)) {
            logger.debug((Object)"isMultiplicityUndefined");
            ocraSubComponentType.setComponentTypeName(subCompTypeStr);
        } else if (StringArrayUtil.isSameValues((String[])componentInstanceMultiplicityBoundaries)) {
            logger.debug((Object)"isFixedSizeOfInstances");
            ocraSubComponentType.setArrayComponentTypeName(subCompTypeStr);
            ocraSubComponentType.setArraySize(this.stringToOcraExpression(componentInstanceMultiplicityBoundaries[1]));
        } else if (StringArrayUtil.isDifferentValues((String[])componentInstanceMultiplicityBoundaries)) {
            throw new Exception("The sub-component\"" + subCompNameStr + "\" cannot have different upper and lower values.");
        }
        return ocraSubComponent;
    }

    private void compileConnections(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList connections = this.abstractSystemModel.getConnectionsPorts(component);
        if (connections != null) {
            for (Object connection : connections) {
                Object sourceConnector = this.abstractSystemModel.getConnectorSource(connection);
                Object targetConnector = this.abstractSystemModel.getConnectorTarget(connection);
                Object sourceOwner = this.abstractSystemModel.getConnectorEndOwner(sourceConnector);
                Object targetOwner = this.abstractSystemModel.getConnectorEndOwner(targetConnector);
                String sourcePortName = this.abstractSystemModel.getConnectorEndName(sourceConnector);
                FullPortId ocraConstraintPortId = this.createFullPortId(sourcePortName);
                if (sourceOwner != component && sourceOwner != null) {
                    ComponentId componentName = this.expressionFactory.createComponentId();
                    componentName.setName(this.abstractSystemModel.getComponentInstanceName(sourceOwner));
                    ocraConstraintPortId.getFullComponentIds().add((Object)componentName);
                }
                String targetPortName = this.abstractSystemModel.getConnectorEndName(targetConnector);
                FullPortId ocraPortId = this.createFullPortId(targetPortName);
                if (targetOwner != component && targetOwner != null) {
                    ComponentId componentName = this.expressionFactory.createComponentId();
                    componentName.setName(this.abstractSystemModel.getComponentInstanceName(targetOwner));
                    ocraPortId.getFullComponentIds().add((Object)componentName);
                }
                Connection ocraConnection = this.ossFactory.createConnection();
                ocraConnection.setVariable((FullVariableId)ocraPortId);
                ocraConnection.setConstraint((Expression)ocraConstraintPortId);
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                ocraRefInstance.setConnection(ocraConnection);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    private void compilePortsConstraints(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList formulaConstraints = this.abstractSystemModel.getFormulaConstraints(component);
        if (formulaConstraints != null) {
            for (Object constraint : formulaConstraints) {
                String strConstraint = this.abstractSystemModel.getFormulaConstraintText(constraint);
                PortConstraint portConstraint = this.stringToOcraConstraint(strConstraint);
                Expression constraintExpression = portConstraint.getConstraint();
                FullVariableId ocraPortId = portConstraint.getVariable();
                IterativeCondition iterCondition = portConstraint.getIterativeCondition();
                Connection ocraConnection = this.ossFactory.createConnection();
                ocraConnection.setConstraint(constraintExpression);
                ocraConnection.setVariable((FullVariableId)((FullPortId)ocraPortId));
                ocraConnection.setIterativeCondition(iterCondition);
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                ocraRefInstance.setConnection(ocraConnection);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    private void compileContractRefinements(Object component, Refinement ocraRefinement) throws Exception {
        List<String> ossContractsNames = this.getOSSContractsNames(component);
        if (ossContractsNames == null || ossContractsNames.isEmpty()) {
            return;
        }
        for (String ossContractName : ossContractsNames) {
            Object refinedContract = this.abstractSystemModel.getContract(component, ossContractName);
            if (refinedContract == null) {
                throw new Exception("The contract " + ossContractName + " is not found in the component " + this.abstractSystemModel.getComponentName(component));
            }
            EList contractRefinements = this.abstractSystemModel.getContractRefinements(refinedContract);
            if (contractRefinements == null || contractRefinements.isEmpty()) {
                return;
            }
            RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
            RefinedBy ocraRefinedBy = this.ossFactory.createRefinedBy();
            ocraRefinedBy.setName(ossContractName);
            for (Object contractRefinement : contractRefinements) {
                Object componentOfContractRefinement = this.abstractSystemModel.getComponentInstanceOfContractRefinement(contractRefinement);
                if (componentOfContractRefinement == null) {
                    throw new Exception("The refinement of the contract " + ossContractName + " of the element " + this.abstractSystemModel.getComponentName(component) + " has the component of the contract instance  == null");
                }
                String componentInstanceName = this.abstractSystemModel.getComponentInstanceName(componentOfContractRefinement);
                Object contractInstanceOfContractRefinement = this.abstractSystemModel.getContractInstanceOfContractRefinement(contractRefinement);
                if (contractInstanceOfContractRefinement == null) {
                    throw new Exception("The refinement " + this.abstractSystemModel.getContractRefinementName(contractRefinement) + " of the element " + this.abstractSystemModel.getComponentName(component) + " has the contract instance == null");
                }
                String contractInstanceName = this.abstractSystemModel.getContractInstanceName(contractInstanceOfContractRefinement);
                String[] componentInstanceRange = this.abstractSystemModel.getComponentInstanceRangeOfContractRefinement(contractRefinement);
                FullContractIdList ocraContractId = this.createFullContractIdList(contractInstanceName, componentInstanceName, componentInstanceRange);
                ocraRefinedBy.getFullContractIds().add((Object)ocraContractId);
            }
            ocraRefInstance.setRefinedby(ocraRefinedBy);
            ocraRefinement.getRefinements().add((Object)ocraRefInstance);
        }
    }

    private FullContractIdList createFullContractIdList(String contractInstanceName, String componentInstanceName, String[] componentInstanceRange) throws Exception {
        FullContractIdList ocraContractId = this.ossFactory.createFullContractIdList();
        ComponentId componentName = this.expressionFactory.createComponentId();
        componentName.setName(componentInstanceName);
        ocraContractId.setName(contractInstanceName);
        if (StringArrayUtil.isSameValues((String[])componentInstanceRange)) {
            logger.debug((Object)"isFixedSizeOfInstances");
            Expression singleIndex = this.stringToOcraExpression(componentInstanceRange[1]);
            ArrayIndex arrayIndex = this.expressionFactory.createArrayIndex();
            arrayIndex.setIndex(singleIndex);
            componentName.getIndexes().add((Object)arrayIndex);
        } else if (StringArrayUtil.isDifferentValues((String[])componentInstanceRange)) {
            logger.debug((Object)("isBoundedNumberOfInstances = " + componentInstanceRange[0] + " - " + componentInstanceRange[1]));
            Expression iteratorIndex = this.stringToOcraExpression("i");
            ArrayIndex arrayIndex = this.expressionFactory.createArrayIndex();
            arrayIndex.setIndex(iteratorIndex);
            Expression lowerExpr = this.stringToOcraExpression(componentInstanceRange[0]);
            Expression upperExpr = this.stringToOcraExpression(componentInstanceRange[1]);
            IteratorBounds iteratorBounds = this.expressionFactory.createIteratorBounds();
            IteratorBound iterator = this.expressionFactory.createIteratorBound();
            iterator.setLowerBound(lowerExpr);
            iterator.setUpperBound(upperExpr);
            iterator.setLeftOperator("<=");
            iterator.setRightOperator("<=");
            iterator.setName("i");
            iteratorBounds.getBounds().add((Object)iterator);
            ocraContractId.getIteratorBounds().add((Object)iteratorBounds);
            componentName.getIndexes().add((Object)arrayIndex);
        }
        ocraContractId.getFullComponentIds().add((Object)componentName);
        return ocraContractId;
    }

    private List<Object> getContractInstancesOfComponent(Object component, List<Object> contracts) {
        ArrayList<Object> contractsOfComponent = new ArrayList<Object>();
        for (Object contract : contracts) {
            if (!this.abstractSystemModel.isContractInstanceOwnerEqualToComponent(contract, component)) continue;
            contractsOfComponent.add(contract);
        }
        return contractsOfComponent;
    }
}

