/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.uml.internal.es2as.ProfileAnalysis;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2ASUtil;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class ModelAnalysis {
    protected final @NonNull UML2AS.Outer converter;
    protected final @NonNull ProfileAnalysis profileAnalysis;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private final @NonNull List<ProfileApplication> asProfileApplications = new ArrayList<ProfileApplication>();
    private final @NonNull Set<Profile> appliedProfiles = new HashSet<Profile>();
    private final @NonNull Map<Profile, Set<Profile>> appliedProfile2appliedProfileClosure = new HashMap<Profile, Set<Profile>>();
    private final @NonNull Map<Package, @NonNull Set<Profile>> package2appliedProfileClosure = new HashMap<Package, Set<Profile>>();
    private final @NonNull Map<EClass, Type> eClass2metatype = new HashMap<EClass, Type>();
    private @Nullable List<EObject> umlStereotypeApplications = null;

    public ModelAnalysis(@NonNull UML2AS.Outer converter, @NonNull ProfileAnalysis profileAnalysis) {
        this.converter = converter;
        this.profileAnalysis = profileAnalysis;
        this.environmentFactory = converter.getEnvironmentFactory();
    }

    public void addProfile(@NonNull Profile asProfile) {
        this.appliedProfiles.add(asProfile);
    }

    public void addProfileApplication(@NonNull ProfileApplication asProfileApplication) {
        this.asProfileApplications.add(asProfileApplication);
        Profile asProfile = asProfileApplication.getAppliedProfile();
        if (asProfile != null) {
            this.appliedProfiles.add(asProfile);
        }
    }

    public void addStereotypeApplication(@NonNull EObject umlStereotypeApplication) {
        List<EObject> umlStereotypeApplications2;
        @NonNull EClass eClass = umlStereotypeApplication.eClass();
        if (UML2AS.ADD_STEREOTYPE_APPLICATION.isActive()) {
            if (umlStereotypeApplication instanceof DynamicEObjectImpl) {
                UML2AS.ADD_STEREOTYPE_APPLICATION.println(NameUtil.qualifiedNameFor((Object)eClass));
            } else {
                UML2AS.ADD_STEREOTYPE_APPLICATION.println(NameUtil.qualifiedNameFor((Object)eClass));
            }
        }
        if ((umlStereotypeApplications2 = this.umlStereotypeApplications) == null) {
            this.umlStereotypeApplications = umlStereotypeApplications2 = new ArrayList<EObject>();
        }
        umlStereotypeApplications2.add(umlStereotypeApplication);
        EPackage ePackage = eClass.getEPackage();
        Resource eResource = ePackage.eResource();
    }

    private void computeAppliedProfile2profileClosure() {
        for (Profile asProfile : this.appliedProfiles) {
            HashSet<Profile> asProfiles = new HashSet<Profile>();
            this.computeProfileClosure(asProfiles, asProfile);
            this.appliedProfile2appliedProfileClosure.put(asProfile, asProfiles);
        }
    }

    private void computeExplicitElementExtensions(@NonNull Map<Element, Map<Stereotype, ElementExtension>> element2stereotype2extension, @NonNull Map<EObject, List<org.eclipse.uml2.uml.Element>> umlStereotypeApplication2umlStereotypedElements, @NonNull Map<Element, @NonNull List<EObject>> asElement2umlStereotypeApplications) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Element asStereotypedElement : asElement2umlStereotypeApplications.keySet()) {
            List<EObject> umlStereotypeApplications = asElement2umlStereotypeApplications.get(asStereotypedElement);
            assert (umlStereotypeApplications != null);
            Map<Stereotype, ElementExtension> stereotype2extension = element2stereotype2extension.get(asStereotypedElement);
            if (stereotype2extension == null) {
                stereotype2extension = new HashMap<Stereotype, ElementExtension>();
                element2stereotype2extension.put(asStereotypedElement, stereotype2extension);
            }
            for (EObject umlStereotypeApplication : umlStereotypeApplications) {
                List<org.eclipse.uml2.uml.Element> umlStereotypedElements = umlStereotypeApplication2umlStereotypedElements.get(umlStereotypeApplication);
                assert (umlStereotypedElements != null);
                Stereotype asStereotype = this.converter.resolveStereotype(umlStereotypeApplication, umlStereotypedElements);
                if (asStereotype == null) {
                    asStereotype = this.converter.resolveStereotype(umlStereotypeApplication, umlStereotypedElements);
                }
                if (asStereotype == null) continue;
                ElementExtension elementExtension = metamodelManager.getElementExtension(asStereotypedElement, asStereotype);
                this.converter.setOriginalMapping((Element)elementExtension, umlStereotypeApplication);
                elementExtension.setIsApplied(true);
                stereotype2extension.put(asStereotype, elementExtension);
                if (!UML2AS.ADD_ELEMENT_EXTENSION.isActive()) continue;
                UML2AS.ADD_ELEMENT_EXTENSION.println(elementExtension.toString());
            }
        }
    }

    private void computePackage2AppliedProfileClosure() {
        for (ProfileApplication asProfileApplication : this.asProfileApplications) {
            Set<Profile> appliedProfileClosure1;
            Profile asProfile;
            Package asPackage = asProfileApplication.getOwningPackage();
            if (asPackage == null || (asProfile = asProfileApplication.getAppliedProfile()) == null || (appliedProfileClosure1 = this.appliedProfile2appliedProfileClosure.get(asProfile)) == null) continue;
            Set<Profile> appliedProfileClosure2 = this.package2appliedProfileClosure.get(asPackage);
            if (appliedProfileClosure2 == null) {
                appliedProfileClosure2 = new HashSet<Profile>();
                this.package2appliedProfileClosure.put(asPackage, appliedProfileClosure2);
            }
            appliedProfileClosure2.addAll(appliedProfileClosure1);
        }
    }

    private void computeProfileClosure(@NonNull Set<Profile> allProfiles, @NonNull Profile asProfile) {
        if (allProfiles.add(asProfile)) {
            for (Package asNestedPackage : asProfile.getOwnedPackages()) {
                if (!(asNestedPackage instanceof Profile)) continue;
                this.computeProfileClosure(allProfiles, (Profile)asNestedPackage);
            }
            for (Package asImportedPackage : asProfile.getImportedPackages()) {
                if (!(asImportedPackage instanceof Profile)) continue;
                this.computeProfileClosure(allProfiles, (Profile)asImportedPackage);
            }
        }
    }

    private void installElementExtensionPropertyValues(@NonNull Map<Element, @NonNull Map<Stereotype, ElementExtension>> element2stereotype2extension, @NonNull Map<EObject, @NonNull List<org.eclipse.uml2.uml.Element>> umlStereotypeApplication2umlStereotypedElements) {
        Map<Element, @NonNull List<EObject>> asElement2umlStereotypeApplications = this.resolveStereotypeApplications(umlStereotypeApplication2umlStereotypedElements);
        this.computeExplicitElementExtensions(element2stereotype2extension, umlStereotypeApplication2umlStereotypedElements, asElement2umlStereotypeApplications);
        for (Element asElement : element2stereotype2extension.keySet()) {
            Map<Stereotype, ElementExtension> stereotype2extension = element2stereotype2extension.get(asElement);
            assert (stereotype2extension != null);
            ArrayList<ElementExtension> newElementExtensions = new ArrayList<ElementExtension>(stereotype2extension.values());
            List oldElementExtensions = asElement.getOwnedExtensions();
            this.converter.refreshList(oldElementExtensions, newElementExtensions);
        }
    }

    public void installStereotypes() {
        this.profileAnalysis.analyze();
        this.computeAppliedProfile2profileClosure();
        this.computePackage2AppliedProfileClosure();
        HashMap<Element, @NonNull Map<Stereotype, ElementExtension>> element2stereotype2extension = new HashMap<Element, Map<Stereotype, ElementExtension>>();
        for (Package asPackage : this.package2appliedProfileClosure.keySet()) {
            if (asPackage == null || asPackage instanceof Profile) continue;
            Set<Profile> appliedProfileClosure = this.package2appliedProfileClosure.get(asPackage);
            assert (appliedProfileClosure != null);
            Map<Type, Set<StereotypeExtender>> metatype2typeExtensions = this.profileAnalysis.computeMetatypes2typeExtensions(appliedProfileClosure);
            this.printMetatypes2StereotypeExtensions(asPackage, metatype2typeExtensions);
            TreeIterator tit = asPackage.eAllContents();
            while (tit.hasNext()) {
                Set<StereotypeExtender> typeExtensions;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Element)) continue;
                Element asElement = (Element)eObject;
                EClass eClass = asElement.eClass();
                Type metatype = this.eClass2metatype.get(eClass);
                if (metatype == null && !this.eClass2metatype.containsKey(eClass)) {
                    EPackage ePackage = eClass.getEPackage();
                    String ePackageName = ePackage.getName();
                    String eClassName = eClass.getName();
                    if (ePackageName != null && eClassName != null) {
                        metatype = this.profileAnalysis.getMetatype(ePackageName, eClassName);
                        this.eClass2metatype.put(eClass, metatype);
                    }
                }
                if (metatype == null || (typeExtensions = metatype2typeExtensions.get(metatype)) == null) continue;
                Map<Stereotype, ElementExtension> stereotype2extension = this.installExtensions(asElement, typeExtensions);
                element2stereotype2extension.put(asElement, stereotype2extension);
            }
        }
        List<EObject> umlStereotypeApplications2 = this.umlStereotypeApplications;
        if (umlStereotypeApplications2 != null) {
            Map<EObject, @NonNull List<org.eclipse.uml2.uml.Element>> umlStereotypeApplication2umlStereotypedElements = UML2ASUtil.computeAppliedStereotypes(umlStereotypeApplications2);
            this.installElementExtensionPropertyValues(element2stereotype2extension, umlStereotypeApplication2umlStereotypedElements);
        }
    }

    private @NonNull Map<Stereotype, ElementExtension> installExtensions(@NonNull Element asElement, @NonNull Set<StereotypeExtender> typeExtensions) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        HashMap<Stereotype, ElementExtension> stereotype2extension = new HashMap<Stereotype, ElementExtension>();
        for (StereotypeExtender typeExtension : typeExtensions) {
            Stereotype stereotype = typeExtension.getOwningStereotype();
            if (stereotype == null) continue;
            ElementExtension elementExtension = metamodelManager.getElementExtension(asElement, stereotype);
            elementExtension.setIsRequired(true);
            stereotype2extension.put(stereotype, elementExtension);
            if (!UML2AS.ADD_ELEMENT_EXTENSION.isActive()) continue;
            UML2AS.ADD_ELEMENT_EXTENSION.println(String.valueOf(asElement.toString()) + " + " + elementExtension.toString());
        }
        return stereotype2extension;
    }

    protected void printMetatypes2StereotypeExtensions(@NonNull Package asPackage, @NonNull Map<Type, @NonNull Set<StereotypeExtender>> metatype2typeExtensions) {
        if (UML2AS.TYPE_EXTENSIONS.isActive()) {
            StringBuffer s = new StringBuffer();
            s.append(String.valueOf(NameUtil.qualifiedNameFor((Object)asPackage)) + " : " + asPackage.getURI());
            ArrayList<Type> metatypes = new ArrayList<Type>(metatype2typeExtensions.keySet());
            Collections.sort(metatypes, NameUtil.NAMEABLE_COMPARATOR);
            for (Type metatype : metatypes) {
                if (metatype == null) continue;
                s.append("\n\t" + NameUtil.qualifiedNameFor((Object)metatype) + " ++");
                Set<StereotypeExtender> typeExtensions = metatype2typeExtensions.get(metatype);
                assert (typeExtensions != null);
                ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                for (StereotypeExtender typeExtension : typeExtensions) {
                    stereotypes.add(typeExtension.getOwningStereotype());
                }
                Collections.sort(stereotypes, NameUtil.NAMEABLE_COMPARATOR);
                for (Stereotype stereotype : stereotypes) {
                    if (stereotype == null) continue;
                    s.append(" " + NameUtil.qualifiedNameFor((Object)stereotype) + ",");
                }
            }
            UML2AS.TYPE_EXTENSIONS.println(s.toString());
        }
    }

    private @NonNull Map<Element, @NonNull List<EObject>> resolveStereotypeApplications(@NonNull Map<EObject, @NonNull List<org.eclipse.uml2.uml.Element>> umlStereotypeApplication2umlStereotypedElements) {
        HashMap<Element, @NonNull List<EObject>> asElement2umlStereotypeApplications = new HashMap<Element, List<EObject>>();
        for (EObject umlStereotypeApplication : umlStereotypeApplication2umlStereotypedElements.keySet()) {
            List<org.eclipse.uml2.uml.Element> umlStereotypedElements = umlStereotypeApplication2umlStereotypedElements.get(umlStereotypeApplication);
            assert (umlStereotypedElements != null);
            for (org.eclipse.uml2.uml.Element umlStereotypedElement : umlStereotypedElements) {
                Element asStereotypedElement = this.converter.getCreated(Element.class, (EObject)umlStereotypedElement);
                if (asStereotypedElement == null) continue;
                ArrayList<EObject> umlPerElementStereotypeApplications = (ArrayList<EObject>)asElement2umlStereotypeApplications.get(asStereotypedElement);
                if (umlPerElementStereotypeApplications == null) {
                    umlPerElementStereotypeApplications = new ArrayList<EObject>();
                    asElement2umlStereotypeApplications.put(asStereotypedElement, umlPerElementStereotypeApplications);
                }
                umlPerElementStereotypeApplications.add(umlStereotypeApplication);
            }
        }
        return asElement2umlStereotypeApplications;
    }

    public static class ElementComparator
    implements Comparator<Element> {
        public static final @NonNull ElementComparator INSTANCE = new ElementComparator();

        @Override
        public int compare(Element o1, Element o2) {
            if (o1 instanceof NamedElement) {
                if (o1 instanceof NamedElement) {
                    String n1 = ((NamedElement)o1).getName();
                    String n2 = ((NamedElement)o2).getName();
                    return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
                }
                return 1;
            }
            if (o1 instanceof NamedElement) {
                return -1;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

