/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.logger;

import eu.fbk.eclipse.standardtools.logger.PluginLogListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private final List<PluginLogListener> pluginLogHooks = new ArrayList<PluginLogListener>();
    private static final String LOG4J_CONFIGURATION_ENV = "LOG4J_CONFIGURATION_FILE";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(Activator.class);
    }

    public void start(BundleContext context) throws Exception {
        this.initLog4j(context);
        super.start(context);
        plugin = this;
    }

    private void initLog4j(BundleContext context) throws Exception {
        this.configureLog4j();
        this.hookPluginLoggers(context);
        LOG.info((Object)"contextInitialized()");
        LOG.trace((Object)"TRACE");
        LOG.debug((Object)"DEBUG");
        LOG.info((Object)"INFO");
        LOG.warn((Object)"WARN");
        LOG.error((Object)"ERROR");
        LOG.fatal((Object)"FATAL");
    }

    public void configureLog4j() throws IOException {
        String log4jfile = System.getenv(LOG4J_CONFIGURATION_ENV);
        if (log4jfile != null && new File(log4jfile).exists()) {
            PropertyConfigurator.configure((String)log4jfile);
            LOG.debug((Object)("Logging using log4j and configuration " + log4jfile));
            System.out.println("Logging using log4j and configuration " + log4jfile);
            LOG.info((Object)("Log4j initialized with " + log4jfile));
        } else {
            log4jfile = LOG4J_PROPERTIES;
            URL confURL = this.getBundle().getEntry(log4jfile);
            PropertyConfigurator.configure((String)FileLocator.toFileURL((URL)confURL).getFile());
            LOG.debug((Object)("Logging using log4j and configuration " + FileLocator.toFileURL((URL)confURL).getFile()));
            System.out.println("Logging using log4j and configuration " + FileLocator.toFileURL((URL)confURL).getFile());
            LOG.info((Object)("Log4j initialized with " + confURL));
        }
        String level = System.getProperty("Log4jLogLevel");
        if (level != null) {
            LOG.debug((Object)("Forced to use logging level '" + level + "' via system property"));
            System.out.println("Forced to use logging level '" + level + "' via system property");
            LogManager.getRootLogger().setLevel(Level.toLevel((String)level));
        }
    }

    private void hookPluginLoggers(BundleContext context) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            ILog pluginLogger = Platform.getLog((Bundle)bundle);
            this.pluginLogHooks.add(new PluginLogListener(pluginLogger, Logger.getLogger((String)bundle.getSymbolicName())));
            LOG.trace((Object)("Added logging hook for bundle: " + bundle.getSymbolicName()));
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

