/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.StringMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public class PapyrusFilterStrategy
implements IFilterStrategy<Object>,
IDisposable {
    private NattableModelManager manager;
    protected final IColumnAccessor<Object> columnAccessor;
    protected CompositeMatcherEditor<Object> rowMatcherEditor;
    protected CompositeMatcherEditor<Object> columnMatcherEditor;
    private FilterList<Object> rowFilterList;
    private FilterList<Object> columnFilterList;
    private Table table;
    private Adapter invertAxisAdapter;

    private INattableModelManager getTableManager() {
        return this.manager;
    }

    public PapyrusFilterStrategy(NattableModelManager manager, IColumnAccessor<Object> columnAccessor) {
        this.columnAccessor = columnAccessor;
        this.manager = manager;
        this.table = this.manager.getTable();
        if (this.table.isInvertAxis()) {
            this.rowFilterList = manager.getVerticalFilterList();
            this.columnFilterList = manager.getHorizontalFilterEventList();
        } else {
            this.rowFilterList = manager.getHorizontalFilterEventList();
            this.columnFilterList = manager.getVerticalFilterList();
        }
        this.invertAxisAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object notifier = msg.getNotifier();
                if (notifier == PapyrusFilterStrategy.this.getTableManager().getTable() && msg.getFeature() == NattablePackage.eINSTANCE.getTable_InvertAxis()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PapyrusFilterStrategy.this.resetFilter();
                        }
                    });
                }
            }
        };
        this.table.eAdapters().add((Object)this.invertAxisAdapter);
        this.rowMatcherEditor = new CompositeMatcherEditor();
        this.rowMatcherEditor.setMode(42);
        this.columnMatcherEditor = new CompositeMatcherEditor();
        this.columnMatcherEditor.setMode(42);
        this.columnFilterList.setMatcherEditor(this.columnMatcherEditor);
        this.rowFilterList.setMatcherEditor(this.rowMatcherEditor);
        this.resetFilter();
    }

    public void resetFilter() {
        this.rowMatcherEditor.getMatcherEditors().clear();
        this.columnMatcherEditor.getMatcherEditors().clear();
    }

    private ReadWriteLock getReadWriteLockToUse() {
        if (this.table.isInvertAxis()) {
            return this.columnFilterList.getReadWriteLock();
        }
        return this.rowFilterList.getReadWriteLock();
    }

    private CompositeMatcherEditor<Object> getMatcherEditorToUse() {
        if (this.table.isInvertAxis()) {
            return this.columnMatcherEditor;
        }
        return this.rowMatcherEditor;
    }

    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        ReadWriteLock filterLock = this.getReadWriteLockToUse();
        CompositeMatcherEditor<Object> matcherEditor = this.getMatcherEditorToUse();
        try {
            filterLock.writeLock().lock();
            matcherEditor.getMatcherEditors().clear();
        }
        finally {
            filterLock.writeLock().unlock();
        }
        if (filterIndexToObjectMap.isEmpty()) {
            return;
        }
        try {
            BasicEventList matcherEditors = new BasicEventList();
            NatTable natTable = (NatTable)this.manager.getAdapter(NatTable.class);
            IConfigRegistry configRegistry = natTable.getConfigRegistry();
            for (Map.Entry<Integer, Object> mapEntry : filterIndexToObjectMap.entrySet()) {
                Integer columnIndex = mapEntry.getKey();
                Object value = mapEntry.getValue();
                StringBuilder configLabel = new StringBuilder("FILTER_COLUMN_");
                configLabel.append(columnIndex.toString());
                IPapyrusMatcherEditorFactory matcherCreator = (IPapyrusMatcherEditorFactory)configRegistry.getConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, "NORMAL", new String[]{configLabel.toString()});
                if (matcherCreator != null) {
                    if (value instanceof Collection) {
                        Collection coll = (Collection)value;
                        Iterator iter = coll.iterator();
                        CompositeMatcherEditor composite = new CompositeMatcherEditor();
                        composite.setMode(24);
                        while (iter.hasNext()) {
                            Object next = iter.next();
                            composite.getMatcherEditors().addAll(matcherCreator.instantiateMatcherEditors(this.columnAccessor, columnIndex, next, configRegistry));
                        }
                        matcherEditors.add((Object)composite);
                        continue;
                    }
                    matcherEditors.addAll(matcherCreator.instantiateMatcherEditors(this.columnAccessor, columnIndex, value, configRegistry));
                    continue;
                }
                Activator.log.warn(NLS.bind((String)"No matcher editor found for column {0}, we will use the default string matcher", (Object)columnIndex));
                matcherEditors.addAll(new StringMatcherEditorFactory<Object>().instantiateMatcherEditors(this.columnAccessor, columnIndex, value, configRegistry));
            }
            try {
                filterLock.writeLock().lock();
                matcherEditor.getMatcherEditors().addAll((Collection)matcherEditors);
            }
            finally {
                filterLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            Activator.log.error("Error on applying a filter", (Throwable)e);
        }
    }

    protected FilterList<?> getRowFilterList() {
        return this.manager.getHorizontalFilterEventList();
    }

    protected ReadWriteLock getHorizontalFilterLock() {
        return this.getRowFilterList().getReadWriteLock();
    }

    public void dispose() {
        this.table.eAdapters().remove((Object)this.invertAxisAdapter);
        this.table = null;
        this.manager = null;
    }
}

