/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardTools.XSapExecService.services;

import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.tools.Request;

public class XSapExecService {
    private static XSapExecService xSapExecService;

    public static XSapExecService getInstance() {
        if (xSapExecService == null) {
            xSapExecService = new XSapExecService();
        }
        return xSapExecService;
    }

    public boolean extendModel(String behaviorModel, String faultExtensions, String faultMode, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder extender = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ExtendModelCommand");
            extender.setParameter("fault_extensions", faultExtensions);
            extender.setParameter("behaviour_model", behaviorModel);
            extender.setParameter("result_file", result);
            extender.setParameter("fault_modes", faultMode);
            extender.setParameter("internal_execution", String.valueOf(internalExecution));
            Object objectResult = extender.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }

    public boolean expandFaultExtensions(String faultExtensions, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder expandFault = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ExpandFeiCommand");
            expandFault.setParameter("fault_extensions", faultExtensions);
            expandFault.setParameter("internal_execution", String.valueOf(internalExecution));
            expandFault.setParameter("result_file", result);
            Object objectResult = expandFault.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }

    public boolean computeFt(String extendedBehaviorModel, String faultMode, String properties, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder computeFt = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ComputeFaultTreeCommand");
            computeFt.setParameter("behaviour_model", extendedBehaviorModel);
            computeFt.setParameter("fault_modes", faultMode);
            computeFt.setParameter("properties", properties);
            computeFt.setParameter("result_file", result);
            computeFt.setParameter("algorithm_type", "msat");
            computeFt.setParameter("compute_probability", String.valueOf(true));
            computeFt.setParameter("internal_execution", String.valueOf(internalExecution));
            Object objectResult = computeFt.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }

    public boolean computeFmea(String extendedBehaviorModel, String faultMode, String properties, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder computeFmea = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ComputeFmeaTableCommand");
            computeFmea.setParameter("behaviour_model", extendedBehaviorModel);
            computeFmea.setParameter("fault_modes", faultMode);
            computeFmea.setParameter("properties", properties);
            computeFmea.setParameter("result_file", result);
            computeFmea.setParameter("algorithm_type", "msat");
            computeFmea.setParameter("internal_execution", String.valueOf(internalExecution));
            Object objectResult = computeFmea.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }
}

