/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.actions.creation.CreateRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionLabelProvider;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.RepresentationSelectionWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SemanticElementSelectionWizardPage;
import org.eclipse.sirius.viewpoint.provider.Messages;

public class CreateRepresentationWizard
extends Wizard {
    private SemanticElementSelectionWizardPage selectElementPage;
    private final Session session;
    private RepresentationSelectionWizardPage representationWizardPage;

    public CreateRepresentationWizard(Session session) {
        this.session = session;
    }

    public void init() {
        this.setWindowTitle(Messages.CreateRepresentationWizard_title);
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        EObject element = this.selectElementPage.getSelectedElement();
        if (element != null) {
            CreateRepresentationAction action = new CreateRepresentationAction(this.session, element, this.representationWizardPage.getRepresentation(), (ILabelProvider)new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
            action.run();
        }
        return true;
    }

    public void addPages() {
        this.representationWizardPage = new RepresentationSelectionWizardPage(this.session);
        this.selectElementPage = new SemanticElementSelectionWizardPage(this.session);
        this.representationWizardPage.setSelectionWizard(this.selectElementPage);
        this.addPage((IWizardPage)this.representationWizardPage);
        this.addPage((IWizardPage)this.selectElementPage);
    }

    public void dispose() {
        super.dispose();
        this.selectElementPage.dispose();
        this.representationWizardPage.dispose();
    }

    public boolean canFinish() {
        return !this.representationWizardPage.isCurrentPageOnWizard() && super.canFinish();
    }
}

